/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network;

import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.time.Duration;
import java.util.Locale;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.addon.network.ExtensionNetwork;
import org.zaproxy.addon.network.ServerCertificatesOptions;
import org.zaproxy.addon.network.internal.cert.CertConfig;
import org.zaproxy.addon.network.internal.cert.CertificateUtils;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.ZapNumberSpinner;
import org.zaproxy.zap.utils.ZapXmlConfiguration;
import org.zaproxy.zap.view.widgets.WritableFileChooser;

class ServerCertificatesOptionsPanel
extends AbstractParamPanel {
    private static final Logger LOGGER = LogManager.getLogger(ServerCertificatesOptionsPanel.class);
    private static final String OWASP_ZAP_ROOT_CA_NAME = "owasp_zap_root_ca";
    private static final String OWASP_ZAP_ROOT_CA_FILE_EXT = ".cer";
    private static final String OWASP_ZAP_ROOT_CA_FILENAME = "owasp_zap_root_ca.cer";
    private static final String CONFIGURATION_FILENAME = "config.xml";
    private static final long serialVersionUID = 1L;
    private final RootCaCertificatePanel rootCaCertificatePanel;
    private final IssuedCertificatesPanel issuedCertificatesPanel;

    public ServerCertificatesOptionsPanel(ExtensionNetwork extensionNetwork) {
        this.rootCaCertificatePanel = new RootCaCertificatePanel(extensionNetwork);
        this.issuedCertificatesPanel = new IssuedCertificatesPanel();
        this.setName(Constant.messages.getString("network.ui.options.servercertificates.name"));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(Constant.messages.getString("network.ui.options.servercertificates.tab.rootcacert"), this.rootCaCertificatePanel.getPanel());
        tabbedPane.add(Constant.messages.getString("network.ui.options.servercertificates.tab.issuedcerts"), this.issuedCertificatesPanel.getPanel());
        GroupLayout mainLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(mainLayout);
        mainLayout.setAutoCreateGaps(true);
        mainLayout.setAutoCreateContainerGaps(true);
        mainLayout.setHorizontalGroup(mainLayout.createParallelGroup().addComponent(tabbedPane));
        mainLayout.setVerticalGroup(mainLayout.createSequentialGroup().addComponent(tabbedPane));
    }

    public void initParam(Object mainOptions) {
        ServerCertificatesOptions options = ServerCertificatesOptionsPanel.getServerCertificatesOptions(mainOptions);
        this.rootCaCertificatePanel.init(options);
        this.issuedCertificatesPanel.init(options);
    }

    private static ServerCertificatesOptions getServerCertificatesOptions(Object mainOptions) {
        return (ServerCertificatesOptions)((OptionsParam)mainOptions).getParamSet(ServerCertificatesOptions.class);
    }

    public void saveParam(Object mainOptions) throws Exception {
        ServerCertificatesOptions options = ServerCertificatesOptionsPanel.getServerCertificatesOptions(mainOptions);
        this.rootCaCertificatePanel.save(options);
        this.issuedCertificatesPanel.save(options);
    }

    public String getHelpIndex() {
        return "addon.network.options.servercertificates";
    }

    private static Duration createValidity(ZapNumberSpinner numberSpinner) {
        return Duration.ofDays(numberSpinner.getValue().intValue());
    }

    private static class IssuedCertificatesPanel {
        private final ZapNumberSpinner numberSpinnerValidity;
        private final JPanel panel;

        IssuedCertificatesPanel() {
            JLabel labelValidity = new JLabel(Constant.messages.getString("network.ui.options.servercertificates.field.certvalidity"));
            this.numberSpinnerValidity = new ZapNumberSpinner(1, 368, 3680);
            this.panel = new JPanel();
            GroupLayout layout = new GroupLayout(this.panel);
            this.panel.setLayout(layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(labelValidity).addComponent((Component)this.numberSpinnerValidity));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(labelValidity).addComponent((Component)this.numberSpinnerValidity, -2, -2, -2));
        }

        JPanel getPanel() {
            return this.panel;
        }

        void init(ServerCertificatesOptions options) {
            this.numberSpinnerValidity.setValue((Object)options.getServerCertValidity().toDays());
        }

        void save(ServerCertificatesOptions options) {
            options.setServerCertValidity(ServerCertificatesOptionsPanel.createValidity(this.numberSpinnerValidity));
        }
    }

    private static class RootCaCertificatePanel {
        private final ZapNumberSpinner numberSpinnerValidity;
        private final JButton buttonGenerate;
        private final JButton buttonImport;
        private final JButton buttonView;
        private final JButton buttonSave;
        private final JTextArea textAreaPem;
        private final ExtensionNetwork extensionNetwork;
        private final JPanel panel;
        private KeyStore currentRootCaCert;

        RootCaCertificatePanel(ExtensionNetwork extensionNetwork) {
            this.extensionNetwork = extensionNetwork;
            JLabel labelValidity = new JLabel(Constant.messages.getString("network.ui.options.servercertificates.field.certvalidity"));
            this.numberSpinnerValidity = new ZapNumberSpinner(1, 365, 3650);
            this.buttonGenerate = RootCaCertificatePanel.createButton("generate", "041.png", e -> this.generateRootCaCert());
            this.buttonImport = RootCaCertificatePanel.createButton("import", "047.png", e -> this.importRootCaCert());
            this.buttonView = RootCaCertificatePanel.createButton("view", "049.png", e -> this.viewRootCaCert());
            this.buttonView.setEnabled(false);
            this.buttonSave = RootCaCertificatePanel.createButton("save", "096.png", e -> this.saveRootCaCert());
            this.buttonSave.setEnabled(false);
            JLabel labelPem = new JLabel(Constant.messages.getString("network.ui.options.servercertificates.field.pem"));
            this.textAreaPem = new JTextArea();
            this.textAreaPem.setEditable(false);
            this.textAreaPem.setFont(FontUtils.getFont((String)"Monospaced"));
            this.textAreaPem.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.checkAndEnableButtons();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.checkAndEnableButtons();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.checkAndEnableButtons();
                }

                private void checkAndEnableButtons() {
                    buttonView.setEnabled(Desktop.isDesktopSupported() && this.isRootCaCertAvailable());
                    buttonSave.setEnabled(this.isRootCaCertAvailable());
                }
            });
            JScrollPane scrollPanePem = new JScrollPane(this.textAreaPem);
            this.panel = new JPanel();
            GroupLayout layout = new GroupLayout(this.panel);
            this.panel.setLayout(layout);
            layout.setAutoCreateGaps(true);
            layout.setAutoCreateContainerGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(labelValidity).addComponent((Component)this.numberSpinnerValidity)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(labelPem).addComponent(scrollPanePem))).addGroup(layout.createParallelGroup().addComponent(this.buttonGenerate).addComponent(this.buttonImport).addComponent(this.buttonView).addComponent(this.buttonSave)));
            layout.setVerticalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(labelValidity).addComponent((Component)this.numberSpinnerValidity)).addGroup(layout.createSequentialGroup().addComponent(labelPem).addComponent(scrollPanePem))).addGroup(layout.createSequentialGroup().addComponent(this.buttonGenerate).addComponent(this.buttonImport).addComponent(this.buttonView).addComponent(this.buttonSave)));
        }

        private static JButton createButton(String name, String iconName, ActionListener action) {
            JButton button = new JButton(Constant.messages.getString("network.ui.options.servercertificates.button." + name), DisplayUtils.getScaledIcon((URL)RootCaCertificatePanel.class.getResource("/resource/icon/16/" + iconName)));
            button.addActionListener(action);
            return button;
        }

        JPanel getPanel() {
            return this.panel;
        }

        void init(ServerCertificatesOptions options) {
            this.setRootCaCert(options.getRootCaKeyStore());
            this.numberSpinnerValidity.setValue((Object)options.getRootCaCertValidity().toDays());
        }

        void save(ServerCertificatesOptions options) {
            if (this.currentRootCaCert != options.getRootCaKeyStore()) {
                options.setRootCaKeyStore(this.currentRootCaCert);
                this.extensionNetwork.applyRootCaCert();
            }
            options.setRootCaCertValidity(ServerCertificatesOptionsPanel.createValidity(this.numberSpinnerValidity));
        }

        private void generateRootCaCert() {
            if (!this.confirmOverwrite()) {
                return;
            }
            try {
                this.setRootCaCert(CertificateUtils.createRootCaKeyStore(new CertConfig(ServerCertificatesOptionsPanel.createValidity(this.numberSpinnerValidity))));
            }
            catch (Exception e) {
                LOGGER.error("An error occurred while generating Root CA certificate", (Throwable)e);
            }
        }

        private boolean confirmOverwrite() {
            if (!this.isRootCaCertAvailable()) {
                return true;
            }
            return JOptionPane.showConfirmDialog(this.panel, Constant.messages.getString("network.ui.options.servercertificates.overwrite.message"), Constant.messages.getString("network.ui.options.servercertificates.overwrite.title"), 0) == 0;
        }

        private boolean isRootCaCertAvailable() {
            return this.textAreaPem.getDocument().getLength() != 0;
        }

        private void saveRootCaCert() {
            WritableFileChooser fileChooser = new WritableFileChooser(new File(System.getProperty("user.home")));
            fileChooser.setFileSelectionMode(0);
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setSelectedFile(new File(ServerCertificatesOptionsPanel.OWASP_ZAP_ROOT_CA_FILENAME));
            if (fileChooser.showSaveDialog(this.panel) != 0) {
                return;
            }
            Path file = fileChooser.getSelectedFile().toPath();
            LOGGER.info("Saving Root CA certificate to {}", (Object)file);
            try {
                this.writePem(file);
            }
            catch (IOException e) {
                LOGGER.error("An error occurred while writing Root CA certificate to file {}", (Object)file, (Object)e);
            }
        }

        private void writePem(Path file) throws IOException {
            try (BufferedWriter bw = Files.newBufferedWriter(file, StandardCharsets.US_ASCII, new OpenOption[0]);){
                bw.write(this.textAreaPem.getText());
            }
        }

        private void importRootCaCert() {
            if (!this.confirmOverwrite()) {
                return;
            }
            JFileChooser fileChooser = new JFileChooser(System.getProperty("user.home"));
            fileChooser.setFileSelectionMode(0);
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setSelectedFile(new File(ServerCertificatesOptionsPanel.CONFIGURATION_FILENAME));
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "config.xml, *.pem";
                }

                @Override
                public boolean accept(File file) {
                    String lcFileName = file.getName().toLowerCase(Locale.ROOT);
                    return lcFileName.endsWith(ServerCertificatesOptionsPanel.CONFIGURATION_FILENAME) || lcFileName.endsWith("pem") || file.isDirectory();
                }
            });
            int result = fileChooser.showOpenDialog(this.panel);
            if (result != 0) {
                return;
            }
            Path file = fileChooser.getSelectedFile().toPath();
            if (Files.notExists(file, new LinkOption[0])) {
                return;
            }
            LOGGER.info("Loading Root CA certificate from {}", (Object)file);
            KeyStore keyStore = null;
            if (file.getFileName().toString().toLowerCase(Locale.ROOT).endsWith("pem")) {
                keyStore = this.convertPemFileToKeyStore(file);
            } else {
                try {
                    ZapXmlConfiguration conf = new ZapXmlConfiguration(file.toFile());
                    String keyStoreString = conf.getString("network.serverCertificates.rootCa.ks");
                    if (keyStoreString == null || keyStoreString.isEmpty()) {
                        JOptionPane.showMessageDialog(this.panel, Constant.messages.getString("network.ui.options.servercertificates.import.config.nocert"), Constant.messages.getString("network.ui.options.servercertificates.import.config.nocert.title"), 0);
                        return;
                    }
                    keyStore = CertificateUtils.stringToKeystore(keyStoreString);
                }
                catch (Exception e) {
                    LOGGER.warn("Error importing Root CA cert from config file:", (Throwable)e);
                    JOptionPane.showMessageDialog(this.panel, Constant.messages.getString("network.ui.options.servercertificates.import.config.error"), Constant.messages.getString("network.ui.options.servercertificates.import.config.error.title"), 0);
                    return;
                }
            }
            if (keyStore != null) {
                this.setRootCaCert(keyStore);
            }
        }

        private KeyStore convertPemFileToKeyStore(Path pemFile) {
            byte[] key;
            byte[] certificate;
            String pem;
            try {
                pem = new String(Files.readAllBytes(pemFile), StandardCharsets.US_ASCII);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to read .pem file:", (Throwable)e);
                JOptionPane.showMessageDialog(this.panel, Constant.messages.getString("network.importpem.failedreadfile", new Object[]{e.getLocalizedMessage()}), Constant.messages.getString("network.importpem.failed.title"), 0);
                return null;
            }
            try {
                certificate = CertificateUtils.extractCertificate(pem);
                if (certificate.length == 0) {
                    JOptionPane.showMessageDialog(this.panel, Constant.messages.getString("network.importpem.nocertsection", new Object[]{"-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----"}), Constant.messages.getString("network.importpem.failed.title"), 0);
                    return null;
                }
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Failed to base64 decode the certificate from .pem file:", (Throwable)e);
                JOptionPane.showMessageDialog(this.panel, Constant.messages.getString("network.importpem.certnobase64"), Constant.messages.getString("network.importpem.failed.title"), 0);
                return null;
            }
            try {
                key = CertificateUtils.extractPrivateKey(pem);
                if (key.length == 0) {
                    JOptionPane.showMessageDialog(this.panel, Constant.messages.getString("network.importpem.noprivkeysection", new Object[]{"-----BEGIN PRIVATE KEY-----", "-----END PRIVATE KEY-----"}), Constant.messages.getString("network.importpem.failed.title"), 0);
                    return null;
                }
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Failed to base64 decode the private key from .pem file:", (Throwable)e);
                JOptionPane.showMessageDialog(this.panel, Constant.messages.getString("network.importpem.privkeynobase64"), Constant.messages.getString("network.importpem.failed.title"), 0);
                return null;
            }
            try {
                return CertificateUtils.pemToKeyStore(certificate, key);
            }
            catch (Exception e) {
                LOGGER.error("Error creating KeyStore for Root CA cert from .pem file:", (Throwable)e);
                JOptionPane.showMessageDialog(this.panel, Constant.messages.getString("network.importpem.failedkeystore", new Object[]{e.getLocalizedMessage()}), Constant.messages.getString("network.importpem.failed.title"), 0);
                return null;
            }
        }

        private void viewRootCaCert() {
            Path file;
            try {
                file = Files.createTempFile(ServerCertificatesOptionsPanel.OWASP_ZAP_ROOT_CA_NAME, ServerCertificatesOptionsPanel.OWASP_ZAP_ROOT_CA_FILE_EXT, new FileAttribute[0]);
                this.writePem(file);
            }
            catch (IOException e) {
                LOGGER.error("An error occured while creating the temporary file", (Throwable)e);
                return;
            }
            try {
                Desktop.getDesktop().open(file.toFile());
            }
            catch (IOException e) {
                LOGGER.error("Error while opening {}", (Object)file, (Object)e);
            }
        }

        private void setRootCaCert(KeyStore rootCaCert) {
            this.currentRootCaCert = rootCaCert;
            this.textAreaPem.setText(CertificateUtils.keyStoreToCertificatePem(rootCaCert));
            this.textAreaPem.setCaretPosition(0);
        }
    }
}

