/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.time.Duration;
import java.util.Arrays;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.addon.network.ExtensionNetwork;
import org.zaproxy.addon.network.internal.cert.CertificateUtils;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiOther;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiView;

public class NetworkApi
extends ApiImplementor {
    private static final Logger LOGGER = LogManager.getLogger(NetworkApi.class);
    private static final String PREFIX = "network";
    private static final String ACTION_GENERATE_ROOT_CA_CERT = "generateRootCaCert";
    private static final String ACTION_IMPORT_ROOT_CA_CERT = "importRootCaCert";
    private static final String ACTION_SET_ROOT_CA_CERT_VALIDITY = "setRootCaCertValidity";
    private static final String ACTION_SET_SERVER_CERT_VALIDITY = "setServerCertValidity";
    private static final String VIEW_GET_ROOT_CA_CERT_VALIDITY = "getRootCaCertValidity";
    private static final String VIEW_GET_SERVER_CERT_VALIDITY = "getServerCertValidity";
    private static final String OTHER_ROOT_CA_CERT = "rootCaCert";
    private static final String PARAM_FILE_PATH = "filePath";
    private static final String PARAM_VALIDITY = "validity";
    private final ExtensionNetwork extensionNetwork;

    public NetworkApi() {
        this(null);
    }

    public NetworkApi(ExtensionNetwork extensionNetwork) {
        this.extensionNetwork = extensionNetwork;
        this.addApiAction(new ApiAction(ACTION_GENERATE_ROOT_CA_CERT));
        this.addApiAction(new ApiAction(ACTION_IMPORT_ROOT_CA_CERT, Arrays.asList(PARAM_FILE_PATH)));
        if (NetworkApi.isHandleServerCerts(extensionNetwork)) {
            this.addApiAction(new ApiAction(ACTION_SET_ROOT_CA_CERT_VALIDITY, Arrays.asList(PARAM_VALIDITY)));
            this.addApiAction(new ApiAction(ACTION_SET_SERVER_CERT_VALIDITY, Arrays.asList(PARAM_VALIDITY)));
            this.addApiView(new ApiView(VIEW_GET_ROOT_CA_CERT_VALIDITY));
            this.addApiView(new ApiView(VIEW_GET_SERVER_CERT_VALIDITY));
        }
        this.addApiOthers(new ApiOther(OTHER_ROOT_CA_CERT, false));
    }

    private static boolean isHandleServerCerts(ExtensionNetwork extensionNetwork) {
        return extensionNetwork == null || extensionNetwork.isHandleServerCerts();
    }

    public String getPrefix() {
        return PREFIX;
    }

    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        switch (name) {
            case "generateRootCaCert": {
                if (this.extensionNetwork.generateRootCaCert()) {
                    return ApiResponseElement.OK;
                }
                return ApiResponseElement.FAIL;
            }
            case "importRootCaCert": {
                Path file = Paths.get(params.getString(PARAM_FILE_PATH), new String[0]);
                String errorMessage = this.extensionNetwork.importRootCaCert(file);
                if (errorMessage == null) {
                    return ApiResponseElement.OK;
                }
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, errorMessage);
            }
            case "setRootCaCertValidity": {
                if (!NetworkApi.isHandleServerCerts(this.extensionNetwork)) {
                    throw new ApiException(ApiException.Type.BAD_ACTION);
                }
                try {
                    Duration validity = Duration.ofDays(params.getInt(PARAM_VALIDITY));
                    this.extensionNetwork.getServerCertificatesOptions().setRootCaCertValidity(validity);
                    return ApiResponseElement.OK;
                }
                catch (Exception e) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_VALIDITY);
                }
            }
            case "setServerCertValidity": {
                if (!NetworkApi.isHandleServerCerts(this.extensionNetwork)) {
                    throw new ApiException(ApiException.Type.BAD_ACTION);
                }
                try {
                    Duration validity = Duration.ofDays(params.getInt(PARAM_VALIDITY));
                    this.extensionNetwork.getServerCertificatesOptions().setServerCertValidity(validity);
                    return ApiResponseElement.OK;
                }
                catch (Exception e) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_VALIDITY);
                }
            }
        }
        throw new ApiException(ApiException.Type.BAD_ACTION);
    }

    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        switch (name) {
            case "getRootCaCertValidity": {
                if (!NetworkApi.isHandleServerCerts(this.extensionNetwork)) {
                    throw new ApiException(ApiException.Type.BAD_VIEW);
                }
                return new ApiResponseElement(name, String.valueOf(this.extensionNetwork.getServerCertificatesOptions().getRootCaCertValidity().toDays()));
            }
            case "getServerCertValidity": {
                if (!NetworkApi.isHandleServerCerts(this.extensionNetwork)) {
                    throw new ApiException(ApiException.Type.BAD_VIEW);
                }
                return new ApiResponseElement(name, String.valueOf(this.extensionNetwork.getServerCertificatesOptions().getServerCertValidity().toDays()));
            }
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    public HttpMessage handleApiOther(HttpMessage msg, String name, JSONObject params) throws ApiException {
        switch (name) {
            case "rootCaCert": {
                KeyStore keyStore = this.extensionNetwork.getRootCaKeyStore();
                if (keyStore == null) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
                }
                String pem = CertificateUtils.keyStoreToCertificatePem(keyStore);
                if (pem.isEmpty()) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR);
                }
                try {
                    msg.setResponseHeader(API.getDefaultResponseHeader((String)"application/pkix-cert;", (int)pem.length()) + "Content-Disposition: attachment; filename=\"ZAPCACert.cer\"\r\n");
                }
                catch (HttpMalformedHeaderException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR);
                }
                msg.setResponseBody(pem);
                return msg;
            }
        }
        throw new ApiException(ApiException.Type.BAD_OTHER);
    }
}

