/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network;

import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.proxy.ProxyServer;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.network.SSLConnector;
import org.parosproxy.paros.security.CachedSslCertifificateServiceImpl;
import org.parosproxy.paros.security.CertData;
import org.parosproxy.paros.security.MissingRootCertificateException;
import org.parosproxy.paros.security.SslCertificateService;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.OptionsDialog;
import org.parosproxy.paros.view.View;
import org.zaproxy.addon.network.NetworkApi;
import org.zaproxy.addon.network.ServerCertificatesOptions;
import org.zaproxy.addon.network.ServerCertificatesOptionsPanel;
import org.zaproxy.addon.network.internal.TlsUtils;
import org.zaproxy.addon.network.internal.cert.CertificateUtils;
import org.zaproxy.addon.network.internal.cert.GenerationException;
import org.zaproxy.addon.network.internal.cert.ServerCertificateGenerator;
import org.zaproxy.addon.network.internal.server.http.HttpServer;
import org.zaproxy.addon.network.internal.server.http.MainProxyHandler;
import org.zaproxy.addon.network.internal.server.http.MainServerHandler;
import org.zaproxy.addon.network.internal.server.http.handlers.CloseOnRecursiveRequestHandler;
import org.zaproxy.addon.network.internal.server.http.handlers.ConnectReceivedHandler;
import org.zaproxy.addon.network.internal.server.http.handlers.DecodeResponseHandler;
import org.zaproxy.addon.network.internal.server.http.handlers.HttpSenderHandler;
import org.zaproxy.addon.network.internal.server.http.handlers.LegacyProxyListenerHandler;
import org.zaproxy.addon.network.internal.server.http.handlers.RemoveAcceptEncodingHandler;
import org.zaproxy.addon.network.server.HttpMessageHandler;
import org.zaproxy.addon.network.server.Server;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.dynssl.DynSSLParam;
import org.zaproxy.zap.extension.dynssl.ExtensionDynSSL;

public class ExtensionNetwork
extends ExtensionAdaptor
implements CommandLineListener {
    private static final Logger LOGGER = LogManager.getLogger(ExtensionNetwork.class);
    private static final String I18N_PREFIX = "network";
    private static final int ARG_CERT_LOAD = 0;
    private static final int ARG_CERT_PUB_DUMP = 1;
    private static final int ARG_CERT_FULL_DUMP = 2;
    Consumer<SslCertificateService> setSslCertificateService;
    boolean handleServerCerts;
    boolean handleLocalServers;
    private LegacyProxyListenerHandler legacyProxyListenerHandler;
    private Object syncGroups = new Object();
    private boolean groupsInitiated;
    private NioEventLoopGroup mainEventLoopGroup;
    private EventExecutorGroup mainEventExecutorGroup;
    private ServerCertificatesOptions serverCertificatesOptions;
    private ServerCertificatesOptionsPanel serverCertificatesOptionsPanel;
    private SslCertificateService sslCertificateService;

    public ExtensionNetwork() {
        super(ExtensionNetwork.class.getSimpleName());
        this.setI18nPrefix(I18N_PREFIX);
        TlsUtils.getSupportedProtocols();
    }

    boolean isHandleServerCerts() {
        return this.handleServerCerts;
    }

    public void init() {
        this.handleServerCerts = ExtensionDynSSL.class.getAnnotation(Deprecated.class) != null;
        this.setSslCertificateService = new Consumer<SslCertificateService>(){
            Method method;

            @Override
            public void accept(SslCertificateService sslCertificateService) {
                try {
                    if (this.method == null) {
                        this.method = SSLConnector.class.getMethod("setSslCertificateService", SslCertificateService.class);
                    }
                    this.method.invoke(SSLConnector.class, sslCertificateService);
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred while setting the certificates service:", (Throwable)e);
                }
            }
        };
        boolean bl = this.handleLocalServers = ProxyServer.class.getAnnotation(Deprecated.class) != null;
        if (!this.handleServerCerts) {
            this.sslCertificateService = new LegacySslCertificateServiceImpl();
        }
    }

    private NioEventLoopGroup getMainEventLoopGroup() {
        if (!this.groupsInitiated) {
            this.initEventGroups();
        }
        return this.mainEventLoopGroup;
    }

    private EventExecutorGroup getMainEventExecutorGroup() {
        if (!this.groupsInitiated) {
            this.initEventGroups();
        }
        return this.mainEventExecutorGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEventGroups() {
        Object object = this.syncGroups;
        synchronized (object) {
            if (this.groupsInitiated) {
                return;
            }
            if (this.mainEventLoopGroup == null) {
                this.mainEventLoopGroup = new NioEventLoopGroup(NettyRuntime.availableProcessors(), (ThreadFactory)new DefaultThreadFactory("ZAP-IO", 10));
            }
            if (this.mainEventExecutorGroup == null) {
                this.mainEventExecutorGroup = new DefaultEventExecutorGroup(NettyRuntime.availableProcessors(), (ThreadFactory)new DefaultThreadFactory("ZAP-IO-EventExecutor", 10));
            }
            this.groupsInitiated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownEventGroups() {
        Object object = this.syncGroups;
        synchronized (object) {
            if (this.mainEventLoopGroup != null) {
                try {
                    this.mainEventLoopGroup.shutdownGracefully().sync();
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Interrupted while waiting for the main event loop group to shutdown.");
                    Thread.currentThread().interrupt();
                    return;
                }
                this.mainEventLoopGroup = null;
            }
            if (this.mainEventExecutorGroup != null) {
                try {
                    this.mainEventExecutorGroup.shutdownGracefully().sync();
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Interrupted while waiting for the main event executor group to shutdown.");
                    Thread.currentThread().interrupt();
                }
            }
            this.groupsInitiated = false;
        }
    }

    public Server createHttpServer(HttpMessageHandler handler) {
        Objects.requireNonNull(handler);
        List<HttpMessageHandler> handlers = Arrays.asList(ConnectReceivedHandler.getSetAndOverrideInstance(), handler);
        return this.createHttpServer(() -> new MainServerHandler(handlers));
    }

    private Server createHttpServer(Supplier<MainServerHandler> handler) {
        return new HttpServer(this.getMainEventLoopGroup(), this.getMainEventExecutorGroup(), this.sslCertificateService, handler);
    }

    public Server createHttpProxy(int initiator, HttpMessageHandler handler) {
        Objects.requireNonNull(handler);
        HttpSender httpSender = new HttpSender(this.getModel().getOptionsParam().getConnectionParam(), true, initiator);
        return this.createHttpProxy(httpSender, handler);
    }

    public Server createHttpProxy(HttpSender httpSender, HttpMessageHandler handler) {
        Objects.requireNonNull(handler);
        Objects.requireNonNull(httpSender);
        List<HttpMessageHandler> handlers = Arrays.asList(ConnectReceivedHandler.getSetAndOverrideInstance(), CloseOnRecursiveRequestHandler.getInstance(), RemoveAcceptEncodingHandler.getEnabledInstance(), DecodeResponseHandler.getEnabledInstance(), handler, new HttpSenderHandler(this.getModel().getOptionsParam().getConnectionParam(), httpSender));
        return this.createHttpServer(() -> new MainProxyHandler(this.legacyProxyListenerHandler, handlers));
    }

    public String getUIName() {
        return Constant.messages.getString("network.ext.name");
    }

    public String getDescription() {
        return Constant.messages.getString("network.ext.desc");
    }

    public void hook(ExtensionHook extensionHook) {
        extensionHook.addApiImplementor((ApiImplementor)new NetworkApi(this));
        this.legacyProxyListenerHandler = new LegacyProxyListenerHandler();
        Control.getSingleton().getExtensionLoader().addProxyServer((ProxyServer)this.legacyProxyListenerHandler);
        if (!this.handleServerCerts) {
            return;
        }
        extensionHook.addCommandLine(ExtensionNetwork.createCommandLineArgs());
        this.sslCertificateService = new SslCertificateServiceImpl();
        this.serverCertificatesOptions = new ServerCertificatesOptions();
        extensionHook.addOptionsParamSet((AbstractParam)this.serverCertificatesOptions);
        if (this.hasView()) {
            OptionsDialog optionsDialog = View.getSingleton().getOptionsDialog("");
            String[] networkNode = new String[]{Constant.messages.getString("network.ui.options.name")};
            this.serverCertificatesOptionsPanel = new ServerCertificatesOptionsPanel(this);
            optionsDialog.addParamPanel(networkNode, (AbstractParamPanel)this.serverCertificatesOptionsPanel, true);
        }
    }

    LegacyProxyListenerHandler getLegacyProxyListenerHandler() {
        return this.legacyProxyListenerHandler;
    }

    private static CommandLineArgument[] createCommandLineArgs() {
        CommandLineArgument[] arguments = new CommandLineArgument[]{new CommandLineArgument("-certload", 1, null, "", "-certload <path>         " + Constant.messages.getString("network.cmdline.certload")), new CommandLineArgument("-certpubdump", 1, null, "", "-certpubdump <path>      " + Constant.messages.getString("network.cmdline.certpubdump")), new CommandLineArgument("-certfulldump", 1, null, "", "-certfulldump <path>     " + Constant.messages.getString("network.cmdline.certfulldump"))};
        return arguments;
    }

    public void execute(CommandLineArgument[] arguments) {
        if (!this.handleServerCerts) {
            return;
        }
        if (arguments[0].isEnabled()) {
            Path file = Paths.get((String)arguments[0].getArguments().firstElement(), new String[0]);
            if (!Files.isReadable(file)) {
                CommandLine.error((String)Constant.messages.getString("network.cmdline.error.noread", new Object[]{file.toAbsolutePath()}));
            } else {
                String error = this.importRootCaCert(file);
                if (error == null) {
                    CommandLine.info((String)Constant.messages.getString("network.cmdline.certload.done", new Object[]{file.toAbsolutePath()}));
                } else {
                    CommandLine.error((String)error);
                }
            }
        }
        if (arguments[1].isEnabled()) {
            ExtensionNetwork.writeCert((String)arguments[1].getArguments().firstElement(), this::writeRootCaCertAsPem);
        }
        if (arguments[2].isEnabled()) {
            ExtensionNetwork.writeCert((String)arguments[2].getArguments().firstElement(), this::writeRootCaCertAndPrivateKeyAsPem);
        }
    }

    private static void writeCert(String path, CertWriter writer) {
        Path file = Paths.get(path, new String[0]);
        if (Files.exists(file, new LinkOption[0]) && !Files.isWritable(file)) {
            CommandLine.error((String)Constant.messages.getString("network.cmdline.error.nowrite", new Object[]{file.toAbsolutePath()}));
        } else {
            try {
                writer.write(file);
                CommandLine.info((String)Constant.messages.getString("network.cmdline.certdump.done", new Object[]{file.toAbsolutePath()}));
            }
            catch (Exception e) {
                CommandLine.error((String)Constant.messages.getString("network.cmdline.error.write", new Object[]{file.toAbsolutePath()}), (Throwable)e);
            }
        }
    }

    public boolean handleFile(File file) {
        return false;
    }

    public List<String> getHandledExtensions() {
        return Collections.emptyList();
    }

    SslCertificateService getSslCertificateService() {
        return this.sslCertificateService;
    }

    ServerCertificatesOptions getServerCertificatesOptions() {
        return this.serverCertificatesOptions;
    }

    public void start() {
        if (!this.handleServerCerts) {
            return;
        }
        if (this.loadRootCaCert()) {
            this.setSslCertificateService(this.sslCertificateService);
        }
    }

    public void stop() {
        this.shutdownEventGroups();
    }

    private void setSslCertificateService(SslCertificateService sslCertificateService) {
        this.setSslCertificateService.accept(sslCertificateService);
    }

    private boolean loadRootCaCert() {
        KeyStore rootCaKeyStore = this.getRootCaKeyStore();
        if (rootCaKeyStore == null) {
            return this.generateRootCaCert();
        }
        if (!this.applyRootCaCert()) {
            return false;
        }
        X509Certificate certificate = CertificateUtils.getCertificate(rootCaKeyStore);
        if (certificate == null || !certificate.getNotAfter().before(new Date())) {
            return true;
        }
        String warnMsg = Constant.messages.getString("network.warn.cert.expired", new Object[]{certificate.getNotAfter().toString(), new Date().toString()});
        if (this.hasView() && this.getView().showConfirmDialog(warnMsg) == 0) {
            if (!this.generateRootCaCert()) {
                this.getView().showWarningDialog(Constant.messages.getString("network.warn.cert.failed"));
            } else {
                Control.getSingleton().getMenuToolsControl().options(Constant.messages.getString("network.ui.options.servercertificates.name"));
            }
            return true;
        }
        LOGGER.warn(warnMsg);
        return true;
    }

    boolean applyRootCaCert() {
        try {
            this.sslCertificateService.initializeRootCA(this.getRootCaKeyStore());
            return true;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while initializing the certificate service:", (Throwable)e);
            return false;
        }
    }

    public boolean canUnload() {
        return true;
    }

    public void unload() {
        Control.getSingleton().getExtensionLoader().removeProxyServer((ProxyServer)this.legacyProxyListenerHandler);
        this.legacyProxyListenerHandler = null;
        if (!this.handleServerCerts) {
            return;
        }
        this.setSslCertificateService(null);
        Security.removeProvider("BC");
        if (this.hasView()) {
            OptionsDialog optionsDialog = View.getSingleton().getOptionsDialog("");
            optionsDialog.removeParamPanel((AbstractParamPanel)this.serverCertificatesOptionsPanel);
        }
    }

    public boolean supportsDb(String type) {
        return true;
    }

    public void writeRootCaCertAsPem(Path path) throws IOException {
        try {
            CertificateUtils.keyStoreToCertificatePem(this.getRootCaKeyStore(), path);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    void writeRootCaCertAndPrivateKeyAsPem(Path path) {
        CertificateUtils.keyStoreToCertificateAndPrivateKeyPem(this.getRootCaKeyStore(), path);
    }

    KeyStore getRootCaKeyStore() {
        if (this.handleServerCerts) {
            return this.serverCertificatesOptions.getRootCaKeyStore();
        }
        DynSSLParam param = (DynSSLParam)Model.getSingleton().getOptionsParam().getParamSet(DynSSLParam.class);
        if (param == null) {
            return null;
        }
        return param.getRootca();
    }

    boolean generateRootCaCert() {
        if (this.handleServerCerts) {
            try {
                LOGGER.info("Creating new root CA certificate.");
                KeyStore keyStore = CertificateUtils.createRootCaKeyStore(this.serverCertificatesOptions.getRootCaCertConfig());
                this.serverCertificatesOptions.setRootCaKeyStore(keyStore);
                LOGGER.info("New root CA certificate created.");
            }
            catch (Exception e) {
                LOGGER.error("Failed to create new root CA certificate:", (Throwable)e);
                return false;
            }
            return this.applyRootCaCert();
        }
        ExtensionDynSSL extDyn = (ExtensionDynSSL)Control.getSingleton().getExtensionLoader().getExtension(ExtensionDynSSL.class);
        if (extDyn != null) {
            try {
                extDyn.createNewRootCa();
                return true;
            }
            catch (Exception e) {
                LOGGER.error("Failed to create the new Root CA cert:", (Throwable)e);
            }
        }
        return false;
    }

    String importRootCaCert(Path pemFile) {
        if (this.handleServerCerts) {
            byte[] key;
            byte[] certificate;
            String pem;
            try {
                pem = new String(Files.readAllBytes(pemFile), StandardCharsets.US_ASCII);
            }
            catch (IOException e) {
                return Constant.messages.getString("network.importpem.failedreadfile", new Object[]{e.getLocalizedMessage()});
            }
            try {
                certificate = CertificateUtils.extractCertificate(pem);
                if (certificate.length == 0) {
                    return Constant.messages.getString("network.importpem.nocertsection", new Object[]{"-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----"});
                }
            }
            catch (IllegalArgumentException e) {
                return Constant.messages.getString("network.importpem.certnobase64");
            }
            try {
                key = CertificateUtils.extractPrivateKey(pem);
                if (key.length == 0) {
                    return Constant.messages.getString("network.importpem.noprivkeysection", new Object[]{"-----BEGIN PRIVATE KEY-----", "-----END PRIVATE KEY-----"});
                }
            }
            catch (IllegalArgumentException e) {
                return Constant.messages.getString("network.importpem.privkeynobase64");
            }
            try {
                KeyStore keyStore = CertificateUtils.pemToKeyStore(certificate, key);
                this.serverCertificatesOptions.setRootCaKeyStore(keyStore);
                this.applyRootCaCert();
                return null;
            }
            catch (Exception e) {
                return Constant.messages.getString("network.importpem.failedkeystore", new Object[]{e.getLocalizedMessage()});
            }
        }
        ExtensionDynSSL extDyn = (ExtensionDynSSL)Control.getSingleton().getExtensionLoader().getExtension(ExtensionDynSSL.class);
        if (extDyn != null) {
            return extDyn.importRootCaCertificate(pemFile.toFile());
        }
        return "";
    }

    private static class LegacySslCertificateServiceImpl
    implements SslCertificateService {
        private LegacySslCertificateServiceImpl() {
        }

        public void initializeRootCA(KeyStore keyStore) {
        }

        public KeyStore createCertForHost(String hostname) {
            return null;
        }

        public KeyStore createCertForHost(CertData certData) throws IOException {
            try {
                return CachedSslCertifificateServiceImpl.getService().createCertForHost(certData);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    class SslCertificateServiceImpl
    implements SslCertificateService {
        private ServerCertificateGenerator generator;

        SslCertificateServiceImpl() {
        }

        public void initializeRootCA(KeyStore keyStore) {
            this.generator = new ServerCertificateGenerator(keyStore, ExtensionNetwork.this.serverCertificatesOptions);
        }

        public KeyStore createCertForHost(String hostname) {
            return null;
        }

        public KeyStore createCertForHost(CertData certData) throws IOException {
            if (this.generator == null) {
                throw new MissingRootCertificateException("The root CA certificate was not set.");
            }
            try {
                return this.generator.generate(certData);
            }
            catch (GenerationException e) {
                throw new IOException(e);
            }
        }
    }

    private static interface CertWriter {
        public void write(Path var1) throws Exception;
    }
}

