/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.junit5.jms.internal;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.Optional;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.junit.platform.commons.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zapodot.jms.common.EmbeddedJMSBrokerHolder;
import org.zapodot.junit5.jms.internal.InjectableFieldsAccessor;

public class FieldInjector {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldInjector.class);

    private FieldInjector() {
    }

    public static void injectToInstance(Object instance, EmbeddedJMSBrokerHolder embeddedJMSBrokerHolder) {
        if (instance.getClass().isMemberClass()) {
            FieldInjector.tryToFindOuterInstance(instance).ifPresent(i -> FieldInjector.injectToInstance(i, embeddedJMSBrokerHolder));
        }
        InjectableFieldsAccessor.findInjectableFields(instance.getClass()).stream().forEach(field -> FieldInjector.injectConnectionFactoryOrURI(instance, field, embeddedJMSBrokerHolder));
    }

    private static Optional<Object> tryToFindOuterInstance(Object innerInstance) {
        return ReflectionUtils.getOutermostInstance((Object)innerInstance, innerInstance.getClass().getDeclaringClass());
    }

    private static void injectConnectionFactoryOrURI(Object instance, Field field, EmbeddedJMSBrokerHolder embeddedJMSBrokerHolder) {
        boolean accessibleOriginal = field.isAccessible();
        field.setAccessible(true);
        try {
            if (ActiveMQConnectionFactory.class.isAssignableFrom(field.getType())) {
                LOGGER.debug("Will inject org.apache.activemq.ActiveMQConnectionFactory to field \"{}\"", (Object)field.getName());
                field.set(instance, embeddedJMSBrokerHolder.getActiveMQConnectionFactory());
            } else if (ConnectionFactory.class.isAssignableFrom(field.getType())) {
                LOGGER.debug("Will inject javax.jms.ConnectionFactory to field \"{}\"", (Object)field.getName());
                field.set(instance, embeddedJMSBrokerHolder.getConnectionFactory());
            } else if (URI.class.isAssignableFrom(field.getType())) {
                LOGGER.debug("Will inject java.net.URI to field \"{}\"", (Object)field.getName());
                field.set(instance, embeddedJMSBrokerHolder.getBrokerUri());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException("Could not inject embedded javax.jms.ConnectionFactory, ActiveMQConnectionFactory or URI to field", e);
        }
        finally {
            field.setAccessible(accessibleOriginal);
        }
    }
}

