/*
 * Decompiled with CFR 0.152.
 */
package org.zapodot.junit5.jms.internal;

import com.google.common.base.Strings;
import java.util.Optional;
import org.zapodot.junit5.jms.annotations.BrokerConfig;
import org.zapodot.junit5.jms.internal.BrokerConfiguration;

public final class BrokerConfigurationBuilder {
    private String name;
    private Boolean marshal;
    private Boolean persistenceEnabled;

    private BrokerConfigurationBuilder() {
    }

    public static BrokerConfigurationBuilder instance() {
        return new BrokerConfigurationBuilder();
    }

    public static BrokerConfigurationBuilder fromInstance(BrokerConfiguration brokerConfiguration) {
        return Optional.ofNullable(brokerConfiguration).map(b -> BrokerConfigurationBuilder.instance().withName(b.getName()).withPersistenceEnabled(b.getPersistenceEnabled()).withMarshal(b.getMarshal())).orElse(BrokerConfigurationBuilder.instance());
    }

    public static BrokerConfigurationBuilder fromBrokerConfigAnnotation(BrokerConfig brokerConfig) {
        return BrokerConfigurationBuilder.instance().withName(Strings.emptyToNull((String)brokerConfig.name())).withMarshal(BrokerConfigurationBuilder.convertFromString(brokerConfig.marshall())).withPersistenceEnabled(BrokerConfigurationBuilder.convertFromString(brokerConfig.persistence()));
    }

    public BrokerConfigurationBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public BrokerConfigurationBuilder withMarshal(Boolean marshal) {
        this.marshal = marshal;
        return this;
    }

    public BrokerConfigurationBuilder withPersistenceEnabled(Boolean persistenceEnabled) {
        this.persistenceEnabled = persistenceEnabled;
        return this;
    }

    public BrokerConfigurationBuilder mergeWithBrokerConfiguration(BrokerConfiguration brokerConfiguration) {
        Optional.ofNullable(brokerConfiguration).ifPresent(b -> {
            this.withName(b.getName());
            this.withMarshal(b.getMarshal());
            this.withPersistenceEnabled(b.getPersistenceEnabled());
        });
        return this;
    }

    private static Boolean convertFromString(String value) {
        return Optional.ofNullable(Strings.emptyToNull((String)value)).map(Boolean::valueOf).orElse(null);
    }

    public BrokerConfiguration build() {
        return new BrokerConfiguration(this.name, this.marshal, this.persistenceEnabled);
    }
}

