/*
 * Decompiled with CFR 0.152.
 */
package de.zalando.stups.swagger.codegen.language;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.JavaClientCodegen;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.zalando.stups.swagger.codegen.ConfigurableCodegenConfig;

public class JaxRsInterfaces
extends JavaClientCodegen
implements CodegenConfig,
ConfigurableCodegenConfig {
    protected String sourceFolder = "";

    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    public String getName() {
        return "jaxrsinterfaces";
    }

    public void preprocessSwagger(Swagger swagger) {
        this.vendorExtensions.put("basePath", swagger.getBasePath());
        super.preprocessSwagger(swagger);
    }

    public String getHelp() {
        return "Generates JAXRS-Interfaces.";
    }

    public JaxRsInterfaces() {
        this.templateDir = "JaxRsInterfaces";
        this.embeddedTemplateDir = "JaxRsInterfaces";
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.put("api.mustache", ".java");
    }

    public List<SupportingFile> supportingFiles() {
        this.supportingFiles.clear();
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", this.apiPackage().replace(".", File.separator), "ApiException.java"));
        this.supportingFiles.add(new SupportingFile("ApiOriginFilter.mustache", this.apiPackage().replace(".", File.separator), "ApiOriginFilter.java"));
        this.supportingFiles.add(new SupportingFile("ApiResponseMessage.mustache", this.apiPackage().replace(".", File.separator), "ApiResponseMessage.java"));
        this.supportingFiles.add(new SupportingFile("NotFoundException.mustache", this.apiPackage().replace(".", File.separator), "NotFoundException.java"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "boolean", "Boolean", "Double", "Integer", "Long", "Float"));
        return this.supportingFiles;
    }

    public String apiFileFolder() {
        return this.outputFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    public String modelFileFolder() {
        return this.outputFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    public String modelPackage() {
        if (this.modelPackage == null || this.modelPackage.trim().isEmpty()) {
            throw new RuntimeException("'modelPackage' should not be null or empty");
        }
        return this.modelPackage;
    }

    public String apiPackage() {
        if (this.apiPackage == null || this.apiPackage.trim().isEmpty()) {
            throw new RuntimeException("'apiPackage' should not be null or empty");
        }
        return this.apiPackage;
    }

    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getTypeDeclaration(inner);
        }
        return super.getTypeDeclaration(p);
    }

    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        int pos;
        String basePath = resourcePath;
        if (basePath.startsWith("/")) {
            basePath = basePath.substring(1);
        }
        if ((pos = basePath.indexOf("/")) > 0) {
            basePath = basePath.substring(0, pos);
        }
        if (basePath == "") {
            basePath = "default";
        } else {
            if (co.path.startsWith("/" + basePath)) {
                co.path = co.path.substring(("/" + basePath).length());
            }
            co.subresourceOperation = !co.path.isEmpty();
        }
        List<CodegenOperation> opList = operations.get(basePath);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(basePath, opList);
        }
        opList.add(co);
        co.baseName = basePath;
    }

    public void processOpts() {
        super.processOpts();
        this.importMapping.remove("SerializedName");
    }

    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        model.imports.remove("SerializedName");
    }

    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                int end;
                String rt;
                if (operation.returnType == null) {
                    operation.returnType = "void";
                    continue;
                }
                if (operation.returnType.startsWith("List")) {
                    rt = operation.returnType;
                    end = rt.lastIndexOf(">");
                    if (end <= 0) continue;
                    operation.returnType = rt.substring("List<".length(), end);
                    operation.returnContainer = "List";
                    continue;
                }
                if (operation.returnType.startsWith("Map")) {
                    rt = operation.returnType;
                    end = rt.lastIndexOf(">");
                    if (end <= 0) continue;
                    operation.returnType = rt.substring("Map<".length(), end);
                    operation.returnContainer = "Map";
                    continue;
                }
                if (!operation.returnType.startsWith("Set") || (end = (rt = operation.returnType).lastIndexOf(">")) <= 0) continue;
                operation.returnType = rt.substring("Set<".length(), end);
                operation.returnContainer = "Set";
            }
        }
        return objs;
    }

    public void setApiPackage(String apiPackage) {
        this.apiPackage = apiPackage;
    }

    public void setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
    }

    public boolean isBuilderSupported() {
        return true;
    }

    public void enableBuilderSupport() {
        this.modelTemplateFiles.put("modelBuilder.mustache", "Builder.java");
    }

    public boolean is303Supported() {
        return false;
    }

    public void enable303() {
    }

    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        name = this.sanitizeName(name);
        return JaxRsInterfaces.camelize((String)name) + "Api";
    }

    public void skipApiGeneration() {
    }

    public void skipModelGeneration() {
    }
}

