/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.crypto;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.crypto.Decrypter;
import org.zalando.crypto.Encrypter;

public final class NoOpCrypter
implements Encrypter,
Decrypter {
    private final Logger logger = LoggerFactory.getLogger(NoOpCrypter.class);
    private final boolean loggingEnabled;

    public NoOpCrypter() {
        this(false);
    }

    public NoOpCrypter(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    @Override
    public String decrypt(String text) {
        if (this.loggingEnabled) {
            this.logger.debug("TO DECRYPT : {}", (Object)text);
        }
        return text;
    }

    @Override
    public String encrypt(String text) {
        if (this.loggingEnabled) {
            this.logger.debug("TO ENCRYPT : {}", (Object)text);
        }
        return text;
    }
}

