/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.crypto;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.zalando.crypto.Decrypter;
import org.zalando.crypto.Prefixed;

public final class Decrypters {
    public static List<Decrypter> prefixedDecrypters(List<Decrypter> toFilter) {
        return Lists.newArrayList((Iterable)Iterables.filter(toFilter, (Predicate)new PrefixedDecrypterPredicate()));
    }

    public static List<Decrypter> nonPrefixedDecrypters(List<Decrypter> toFilter) {
        return Lists.newArrayList((Iterable)Iterables.filter(toFilter, (Predicate)new PrefixedDecrypterPredicate()));
    }

    public static List<Decrypter> findByPrefix(List<Decrypter> decrypters, String prefix) {
        Preconditions.checkNotNull(decrypters, (Object)"'Decrypter's-list should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)prefix) ? 1 : 0) != 0, (Object)"'prefix' should never be null or empty.");
        return Lists.newArrayList((Iterable)Iterables.filter(decrypters, (Predicate)Predicates.and((Predicate)new PrefixedDecrypterPredicate(), (Predicate)new PrefixPredicate(prefix))));
    }

    static class NonPrefixedDecrypterPredicate
    implements Predicate<Decrypter> {
        NonPrefixedDecrypterPredicate() {
        }

        public boolean apply(Decrypter input) {
            return !(input instanceof Prefixed);
        }
    }

    static class PrefixedDecrypterPredicate
    implements Predicate<Decrypter> {
        PrefixedDecrypterPredicate() {
        }

        public boolean apply(Decrypter input) {
            return input instanceof Prefixed;
        }
    }

    static class PrefixPredicate
    implements Predicate<Decrypter> {
        private final String prefix;

        public PrefixPredicate(String prefix) {
            this.prefix = prefix;
        }

        public boolean apply(Decrypter input) {
            return this.prefix.equals(((Prefixed)((Object)input)).getPrefix());
        }
    }
}

