/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.riptide.soap;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;

public final class SOAPFaultHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    private final String protocol;

    public SOAPFaultHttpMessageConverter() {
        this("SOAP 1.1 Protocol");
    }

    public SOAPFaultHttpMessageConverter(String protocol) {
        super(MediaType.TEXT_XML);
        this.protocol = protocol;
    }

    protected boolean supports(Class<?> type) {
        return type == SOAPFault.class;
    }

    public boolean canWrite(Class<?> type, @Nullable MediaType mediaType) {
        return false;
    }

    @Nonnull
    protected Object readInternal(Class<?> type, HttpInputMessage message) throws IOException, HttpMessageNotReadableException {
        try {
            MessageFactory factory = MessageFactory.newInstance((String)this.protocol);
            SOAPMessage soapMessage = factory.createMessage(null, message.getBody());
            return soapMessage.getSOAPBody().getFault();
        }
        catch (SOAPException e) {
            throw new HttpMessageNotReadableException(e.getMessage(), (Throwable)e, message);
        }
    }

    protected void writeInternal(Object o, HttpOutputMessage message) {
        throw new UnsupportedOperationException();
    }
}

