/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.zalando.problem.StatusType;
import org.zalando.problem.gson.UnknownStatus;

final class StatusTypeAdapter
extends TypeAdapter<StatusType> {
    private Map<Integer, StatusType> index;

    public void write(JsonWriter out, @Nullable StatusType status) throws IOException {
        if (Objects.isNull(status)) {
            out.nullValue();
            return;
        }
        out.value((long)status.getStatusCode());
    }

    public StatusType read(JsonReader in) throws IOException {
        JsonToken peek = in.peek();
        if (peek == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        int statusCode = in.nextInt();
        @Nullable StatusType status = this.index.get(statusCode);
        return status == null ? new UnknownStatus(statusCode) : status;
    }

    public StatusTypeAdapter(Map<Integer, StatusType> index) {
        this.index = index;
    }
}

