/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.spring.webflux;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import lombok.Generated;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MimeType;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.spring.webflux.State;

final class ServerRequest
implements HttpRequest {
    private final ServerHttpRequest request;
    private final AtomicReference<State> state = new AtomicReference<State.Unbuffered>(new State.Unbuffered());

    public Origin getOrigin() {
        return Origin.REMOTE;
    }

    public HttpHeaders getHeaders() {
        return HttpHeaders.of((Map)this.request.getHeaders());
    }

    public String getRemote() {
        return Optional.ofNullable(this.request.getRemoteAddress()).map(InetSocketAddress::toString).orElse("");
    }

    public String getMethod() {
        return this.request.getMethod().name();
    }

    public String getScheme() {
        return this.request.getURI().getScheme();
    }

    public String getHost() {
        return this.request.getURI().getHost();
    }

    public Optional<Integer> getPort() {
        return Optional.of(this.request.getURI().getPort()).filter(p -> p != -1);
    }

    public String getPath() {
        return this.request.getPath().value();
    }

    public String getQuery() {
        return Optional.ofNullable(this.request.getURI().getQuery()).orElse("");
    }

    @Nullable
    public String getContentType() {
        return Optional.ofNullable(this.request.getHeaders().getContentType()).map(MimeType::toString).orElse(null);
    }

    public Charset getCharset() {
        return Optional.ofNullable(this.request.getHeaders().getContentType()).map(MimeType::getCharset).orElse(StandardCharsets.UTF_8);
    }

    public HttpRequest withBody() throws IOException {
        this.state.updateAndGet(State::with);
        return this;
    }

    public HttpRequest withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    boolean shouldBuffer() {
        return this.state.get() instanceof State.Offering;
    }

    void buffer(byte[] message) {
        this.state.updateAndGet(s -> s.buffer(message));
    }

    public byte[] getBody() throws IOException {
        return this.state.get().getBody();
    }

    @Generated
    public ServerRequest(ServerHttpRequest request) {
        this.request = request;
    }
}

