/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.spring.webflux;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.zalando.logbook.spring.webflux.DataBufferCopyUtils;
import org.zalando.logbook.spring.webflux.ServerRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class BufferingServerHttpRequest
extends ServerHttpRequestDecorator {
    private static final Set<HttpMethod> METHODS_WITHOUT_BODY = new HashSet<HttpMethod>(Arrays.asList(HttpMethod.GET, HttpMethod.DELETE, HttpMethod.TRACE, HttpMethod.OPTIONS, HttpMethod.HEAD));
    private final ServerRequest serverRequest;
    private final Runnable writeHook;

    BufferingServerHttpRequest(ServerHttpRequest delegate, ServerRequest serverRequest, Runnable writeHook) {
        super(delegate);
        this.serverRequest = serverRequest;
        this.writeHook = writeHook;
        if (METHODS_WITHOUT_BODY.contains(super.getMethod()) || !serverRequest.shouldBuffer()) {
            writeHook.run();
        }
    }

    public Flux<DataBuffer> getBody() {
        return Flux.from(this.bufferingWrap((Publisher<? extends DataBuffer>)super.getBody()));
    }

    private Publisher<? extends DataBuffer> bufferingWrap(Publisher<? extends DataBuffer> body) {
        if (this.serverRequest.shouldBuffer()) {
            return Flux.from(DataBufferCopyUtils.wrapAndBuffer(body, this.serverRequest::buffer)).doOnComplete(this.writeHook);
        }
        return Mono.fromRunnable((Runnable)this.writeHook).thenMany(body);
    }
}

