/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import lombok.Generated;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.Origin;
import org.zalando.logbook.netty.HeaderSupport;
import org.zalando.logbook.netty.State;
import org.zalando.logbook.netty.Unbuffered;

final class Request
implements HttpRequest,
HeaderSupport {
    private final AtomicReference<State> state = new AtomicReference<Unbuffered>(new Unbuffered());
    private final ChannelHandlerContext context;
    private final Origin origin;
    private final io.netty.handler.codec.http.HttpRequest request;
    private final URI uri;

    public Request(ChannelHandlerContext context, Origin origin, io.netty.handler.codec.http.HttpRequest request) {
        this(context, origin, request, URI.create(request.uri()));
    }

    public String getProtocolVersion() {
        return this.request.protocolVersion().text();
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public String getRemote() {
        return this.context.channel().remoteAddress().toString();
    }

    public String getMethod() {
        return this.request.method().name();
    }

    public String getScheme() {
        return "http";
    }

    public String getHost() {
        return this.request.headers().get((CharSequence)HttpHeaderNames.HOST, "unknown");
    }

    public Optional<Integer> getPort() {
        return Optional.empty();
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public String getQuery() {
        return Optional.ofNullable(this.uri.getQuery()).orElse("");
    }

    public HttpHeaders getHeaders() {
        return this.copyOf((Iterable)this.request.headers());
    }

    @Nullable
    public String getContentType() {
        return this.request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
    }

    public Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    public HttpRequest withBody() {
        this.state.updateAndGet(State::with);
        return this;
    }

    public HttpRequest withoutBody() {
        this.state.updateAndGet(State::without);
        return this;
    }

    void buffer(ByteBuf content) {
        this.state.updateAndGet(state -> state.buffer((HttpMessage)this.request, content));
    }

    public byte[] getBody() {
        return this.state.get().getBody();
    }

    @Generated
    private Request(ChannelHandlerContext context, Origin origin, io.netty.handler.codec.http.HttpRequest request, URI uri) {
        this.context = context;
        this.origin = origin;
        this.request = request;
        this.uri = uri;
    }
}

