/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import org.zalando.logbook.ForwardingHttpRequest;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.attributes.HttpAttributes;
import org.zalando.logbook.core.Cache;

final class CachingHttpRequest
implements ForwardingHttpRequest {
    private final HttpRequest request;
    private final Cache<HttpHeaders> headers;
    private final HttpAttributes httpAttributes;

    CachingHttpRequest(HttpRequest request) {
        this(request, HttpAttributes.EMPTY);
    }

    CachingHttpRequest(HttpRequest request, HttpAttributes httpAttributes) {
        this.request = request;
        this.headers = new Cache<HttpHeaders>(() -> ((HttpRequest)request).getHeaders());
        this.httpAttributes = httpAttributes;
    }

    public HttpRequest delegate() {
        return this.request;
    }

    public HttpHeaders getHeaders() {
        return this.headers.get();
    }

    public HttpAttributes getAttributes() {
        return this.httpAttributes;
    }
}

