/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import java.util.Spliterator;
import java.util.function.Consumer;

final class ChunkingSpliterator
implements Spliterator<String> {
    private final String string;
    private final int minChunkSize;
    private final int maxChunkSize;
    private int position;

    ChunkingSpliterator(String string, int minChunkSize, int maxChunkSize) {
        if (maxChunkSize <= 0) {
            throw new IllegalArgumentException("maxChunkSize is expected to be greater than zero");
        }
        if (minChunkSize <= 0) {
            throw new IllegalArgumentException("minChunkSize is expected to be greater than zero");
        }
        if (minChunkSize > maxChunkSize) {
            throw new IllegalArgumentException("minChunkSize is expected to be less or equal to " + maxChunkSize);
        }
        this.string = string;
        this.minChunkSize = minChunkSize;
        this.maxChunkSize = maxChunkSize;
    }

    @Override
    public boolean tryAdvance(Consumer<? super String> action) {
        if (this.position >= this.string.length()) {
            return false;
        }
        String chunk = this.nextChunk();
        action.accept(chunk);
        this.position += chunk.length();
        return true;
    }

    @Override
    public Spliterator<String> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        int size = this.minChunkSize + (this.maxChunkSize - this.minChunkSize) / 2;
        return this.string.length() / size + Integer.signum(this.string.length() % size);
    }

    @Override
    public int characteristics() {
        return 0x510 | (this.minChunkSize == this.maxChunkSize ? 64 : 0);
    }

    private String nextChunk() {
        int chunkMax = this.position + this.maxChunkSize;
        if (chunkMax >= this.string.length()) {
            return this.string.substring(this.position);
        }
        int chunkMin = this.position + this.minChunkSize;
        for (int i = chunkMax; i >= chunkMin; --i) {
            char ch = this.string.charAt(i - 1);
            if (!ChunkingSpliterator.isSplitCharacter(ch)) continue;
            return this.string.substring(this.position, i);
        }
        return this.string.substring(this.position, chunkMax);
    }

    private static boolean isSplitCharacter(char ch) {
        return ch == ' ' || ch == ',' || ch == ':';
    }
}

