/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core.attributes;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.attributes.AttributeExtractor;
import org.zalando.logbook.attributes.HttpAttributes;
import org.zalando.logbook.core.attributes.JwtClaimsExtractor;

@API(status=API.Status.EXPERIMENTAL)
public final class JwtAllMatchingClaimsExtractor
implements AttributeExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtAllMatchingClaimsExtractor.class);
    private static final String DEFAULT_SUBJECT_CLAIM = "sub";
    private final List<String> claimNames;
    private final JwtClaimsExtractor jwtClaimsExtractor;

    public JwtAllMatchingClaimsExtractor(ObjectMapper objectMapper, List<String> claimNames) {
        this.claimNames = claimNames;
        this.jwtClaimsExtractor = new JwtClaimsExtractor(objectMapper, new ArrayList<String>(claimNames));
    }

    @Nonnull
    private static JwtAllMatchingClaimsExtractor create(@Nullable ObjectMapper objectMapper, @Nullable List<String> claimNames) {
        return new JwtAllMatchingClaimsExtractor(Optional.ofNullable(objectMapper).orElse(new ObjectMapper()), Optional.ofNullable(claimNames).orElse(Collections.singletonList(DEFAULT_SUBJECT_CLAIM)));
    }

    @Nonnull
    public HttpAttributes extract(HttpRequest request) {
        try {
            Map<String, Object> attributeMap = this.jwtClaimsExtractor.extractClaims(request).entrySet().stream().filter(entry -> this.claimNames.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> this.jwtClaimsExtractor.toStringValue(entry.getValue())));
            return new HttpAttributes(attributeMap);
        }
        catch (Exception e) {
            log.trace("Encountered error while extracting attributes: `{}`", (Object)Optional.ofNullable(e.getCause()).orElse(e).getMessage());
            return HttpAttributes.EMPTY;
        }
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtAllMatchingClaimsExtractor)) {
            return false;
        }
        JwtAllMatchingClaimsExtractor other = (JwtAllMatchingClaimsExtractor)o;
        List<String> this$claimNames = this.claimNames;
        List<String> other$claimNames = other.claimNames;
        if (this$claimNames == null ? other$claimNames != null : !((Object)this$claimNames).equals(other$claimNames)) {
            return false;
        }
        JwtClaimsExtractor this$jwtClaimsExtractor = this.jwtClaimsExtractor;
        JwtClaimsExtractor other$jwtClaimsExtractor = other.jwtClaimsExtractor;
        return !(this$jwtClaimsExtractor == null ? other$jwtClaimsExtractor != null : !((Object)this$jwtClaimsExtractor).equals(other$jwtClaimsExtractor));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $claimNames = this.claimNames;
        result = result * 59 + ($claimNames == null ? 43 : ((Object)$claimNames).hashCode());
        JwtClaimsExtractor $jwtClaimsExtractor = this.jwtClaimsExtractor;
        result = result * 59 + ($jwtClaimsExtractor == null ? 43 : ((Object)$jwtClaimsExtractor).hashCode());
        return result;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static final class Builder {
        @Generated
        private ObjectMapper objectMapper;
        @Generated
        private List<String> claimNames;

        @Generated
        Builder() {
        }

        @Generated
        public Builder objectMapper(@Nullable ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        @Generated
        public Builder claimNames(@Nullable List<String> claimNames) {
            this.claimNames = claimNames;
            return this;
        }

        @Generated
        public JwtAllMatchingClaimsExtractor build() {
            return JwtAllMatchingClaimsExtractor.create(this.objectMapper, this.claimNames);
        }

        @Generated
        public String toString() {
            return "JwtAllMatchingClaimsExtractor.Builder(objectMapper=" + this.objectMapper + ", claimNames=" + this.claimNames + ")";
        }
    }
}

