/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core.attributes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.attributes.AttributeExtractor;
import org.zalando.logbook.attributes.HttpAttributes;

@API(status=API.Status.EXPERIMENTAL)
public final class CompositeAttributeExtractor
implements AttributeExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompositeAttributeExtractor.class);
    private final List<AttributeExtractor> attributeExtractors;

    @Nonnull
    public HttpAttributes extract(HttpRequest request) {
        HashMap map = new HashMap();
        ArrayList<String> exceptions = new ArrayList<String>();
        for (AttributeExtractor attributeExtractor : this.attributeExtractors) {
            try {
                map.putAll(attributeExtractor.extract(request));
            }
            catch (Exception e) {
                exceptions.add(String.format("[%s: %s]", attributeExtractor.getClass().getName(), Optional.ofNullable(e.getCause()).orElse(e).getMessage()));
            }
        }
        if (!exceptions.isEmpty()) {
            log.trace("Encountered errors while extracting attributes: {}", (Object)String.join((CharSequence)", ", exceptions));
        }
        return new HttpAttributes(map);
    }

    @Nonnull
    public HttpAttributes extract(HttpRequest request, HttpResponse response) {
        HashMap map = new HashMap();
        for (AttributeExtractor attributeExtractor : this.attributeExtractors) {
            map.putAll(this.safeRequestExtractor(attributeExtractor, request, response));
        }
        return new HttpAttributes(map);
    }

    @Nonnull
    private HttpAttributes safeRequestExtractor(AttributeExtractor attributeExtractor, HttpRequest request, HttpResponse response) {
        try {
            return attributeExtractor.extract(request, response);
        }
        catch (Exception e) {
            log.trace("{} encountered error while extracting attributes: `{}`", attributeExtractor.getClass(), (Object)Optional.ofNullable(e.getCause()).orElse(e).getMessage());
            return HttpAttributes.EMPTY;
        }
    }

    @Generated
    public CompositeAttributeExtractor(List<AttributeExtractor> attributeExtractors) {
        this.attributeExtractors = attributeExtractors;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompositeAttributeExtractor)) {
            return false;
        }
        CompositeAttributeExtractor other = (CompositeAttributeExtractor)o;
        List<AttributeExtractor> this$attributeExtractors = this.attributeExtractors;
        List<AttributeExtractor> other$attributeExtractors = other.attributeExtractors;
        return !(this$attributeExtractors == null ? other$attributeExtractors != null : !((Object)this$attributeExtractors).equals(other$attributeExtractors));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AttributeExtractor> $attributeExtractors = this.attributeExtractors;
        result = result * 59 + ($attributeExtractors == null ? 43 : ((Object)$attributeExtractors).hashCode());
        return result;
    }
}

