/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.BodyFilter;
import org.zalando.logbook.common.MediaTypeQuery;

final class CompactingXmlBodyFilter
implements BodyFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompactingXmlBodyFilter.class);
    private static final Predicate<String> XML = MediaTypeQuery.compile((String)"*/xml", (String[])new String[]{"*/*+xml"});
    private final DocumentBuilderFactory factory = this.documentBuilderFactory();
    private final Transformer transformer = this.transformer();

    CompactingXmlBodyFilter() {
    }

    public String filter(@Nullable String contentType, String body) {
        return XML.test(contentType) && this.shouldCompact(body) ? this.compact(body) : body;
    }

    private boolean shouldCompact(String body) {
        return body.indexOf(10) != -1;
    }

    private String compact(String body) {
        try {
            StringWriter output = new StringWriter();
            Document document = this.parseDocument(body);
            this.transformer.transform(new DOMSource(document), new StreamResult(output));
            return output.toString();
        }
        catch (Exception e) {
            log.trace("Unable to compact body, is it a XML?. Keep it as-is: `{}`", (Object)e.getMessage());
            return body;
        }
    }

    private Document parseDocument(String body) throws Exception {
        DocumentBuilder documentBuilder = this.factory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(body.getBytes()));
        this.removeEmptyTextNodes(document);
        return document;
    }

    private void removeEmptyTextNodes(Document document) throws Exception {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xpath = xPathFactory.newXPath();
        NodeList empty = (NodeList)xpath.evaluate("//text()[normalize-space(.) = '']", document, XPathConstants.NODESET);
        for (int i = 0; i < empty.getLength(); ++i) {
            Node node = empty.item(i);
            node.getParentNode().removeChild(node);
        }
    }

    private Transformer transformer() {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = (Transformer)FauxPas.throwingSupplier(factory::newTransformer).get();
        transformer.setOutputProperty("indent", "no");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        return transformer;
    }

    private DocumentBuilderFactory documentBuilderFactory() {
        return (DocumentBuilderFactory)FauxPas.throwingSupplier(() -> {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            return factory;
        }).get();
    }
}

