/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apiguardian.api.API;
import org.zalando.fauxpas.FauxPas;
import org.zalando.logbook.Correlation;
import org.zalando.logbook.HttpMessage;
import org.zalando.logbook.HttpRequest;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.Precorrelation;
import org.zalando.logbook.Sink;
import org.zalando.logbook.core.BodyReplacementHttpRequest;
import org.zalando.logbook.core.BodyReplacementHttpResponse;
import org.zalando.logbook.core.ChunkingSpliterator;

@API(status=API.Status.EXPERIMENTAL)
public final class ChunkingSink
implements Sink {
    private static final int MIN_MAX_DELTA = 16;
    private final Sink delegate;
    private final int minChunkSize;
    private final int maxChunkSize;

    public ChunkingSink(Sink delegate, int size) {
        this.delegate = delegate;
        if (size <= 0) {
            throw new IllegalArgumentException("size is expected to be greater than zero");
        }
        this.minChunkSize = size > 16 ? size - 16 : size;
        this.maxChunkSize = size;
    }

    public boolean isActive() {
        return this.delegate.isActive();
    }

    public void write(Precorrelation precorrelation, HttpRequest original) throws IOException {
        this.chunk((HttpMessage)original).map(chunk -> new BodyReplacementHttpRequest(original, (String)chunk)).forEach((Consumer<BodyReplacementHttpRequest>)FauxPas.throwingConsumer(replaced -> this.delegate.write(precorrelation, (HttpRequest)replaced)));
    }

    public void write(Correlation correlation, HttpRequest request, HttpResponse original) throws IOException {
        this.chunk((HttpMessage)original).map(chunk -> new BodyReplacementHttpResponse(original, (String)chunk)).forEach((Consumer<BodyReplacementHttpResponse>)FauxPas.throwingConsumer(replaced -> this.delegate.write(correlation, request, (HttpResponse)replaced)));
    }

    private Stream<String> chunk(HttpMessage message) throws IOException {
        if (message.getBodyAsString().isEmpty()) {
            return Stream.of("");
        }
        return StreamSupport.stream(new ChunkingSpliterator(message.getBodyAsString(), this.minChunkSize, this.maxChunkSize), false);
    }
}

