/*
 * Decompiled with CFR 0.152.
 */
package org.yeauty.support;

import io.netty.channel.Channel;
import java.util.Collections;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.yeauty.annotation.PathVariable;
import org.yeauty.pojo.PojoEndpointServer;
import org.yeauty.support.MethodArgumentResolver;

public class PathVariableMapMethodArgumentResolver
implements MethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        PathVariable ann = (PathVariable)parameter.getParameterAnnotation(PathVariable.class);
        return ann != null && Map.class.isAssignableFrom(parameter.getParameterType()) && !StringUtils.hasText((String)ann.value());
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, Channel channel, Object object) throws Exception {
        PathVariable ann = (PathVariable)parameter.getParameterAnnotation(PathVariable.class);
        String name = ann.name();
        if (name.isEmpty() && (name = parameter.getParameterName()) == null) {
            throw new IllegalArgumentException("Name for argument type [" + parameter.getNestedParameterType().getName() + "] not available, and parameter name information not found in class file either.");
        }
        Map uriTemplateVars = (Map)channel.attr(PojoEndpointServer.URI_TEMPLATE).get();
        if (!CollectionUtils.isEmpty((Map)uriTemplateVars)) {
            return uriTemplateVars;
        }
        return Collections.emptyMap();
    }
}

