/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.jedis.utils.lua;

import java.util.LinkedHashMap;
import java.util.List;
import org.yatech.jedis.utils.lua.BasicLuaScript;
import org.yatech.jedis.utils.lua.LuaKeyArgument;
import org.yatech.jedis.utils.lua.LuaPreparedScript;
import org.yatech.jedis.utils.lua.LuaPreparedScriptUtils;
import org.yatech.jedis.utils.lua.LuaScriptConfig;
import org.yatech.jedis.utils.lua.LuaValueArgument;
import redis.clients.jedis.Jedis;

class ThreadSafeLuaPreparedScript
extends BasicLuaScript
implements LuaPreparedScript {
    private final ThreadLocal<ArgumentsHolder> localArguments;

    ThreadSafeLuaPreparedScript(String scriptText, final List<LuaKeyArgument> keyArguments, final List<LuaValueArgument> valueArguments, LuaScriptConfig config) {
        super(scriptText, config);
        this.localArguments = new ThreadLocal<ArgumentsHolder>(){
            private final ArgumentsHolder template;
            {
                this.template = new ArgumentsHolder(LuaPreparedScriptUtils.toArgMap(keyArguments), LuaPreparedScriptUtils.toArgMap(valueArguments));
            }

            @Override
            protected ArgumentsHolder initialValue() {
                return new ArgumentsHolder(LuaPreparedScriptUtils.cloneArgMap(this.template.name2keyArguments), LuaPreparedScriptUtils.cloneArgMap(this.template.name2valueArguments));
            }
        };
    }

    @Override
    public void setKeyArgument(String name, String key) {
        this.localArguments.get().name2keyArguments.get(name).setValue(key);
    }

    @Override
    public void setValueArgument(String name, String value) {
        this.localArguments.get().name2valueArguments.get(name).setValue(value);
    }

    @Override
    public void setValueArgument(String name, int value) {
        this.localArguments.get().name2valueArguments.get(name).setValue(value);
    }

    @Override
    public void setValueArgument(String name, long value) {
        this.localArguments.get().name2valueArguments.get(name).setValue(value);
    }

    @Override
    public void setValueArgument(String name, double value) {
        this.localArguments.get().name2valueArguments.get(name).setValue(value);
    }

    @Override
    public Object exec(Jedis jedis) {
        ArgumentsHolder holder = this.localArguments.get();
        return this.exec(jedis, LuaPreparedScriptUtils.toExecValues(holder.name2keyArguments), LuaPreparedScriptUtils.toExecValues(holder.name2valueArguments));
    }

    private static class ArgumentsHolder {
        final LinkedHashMap<String, LuaKeyArgument> name2keyArguments;
        final LinkedHashMap<String, LuaValueArgument> name2valueArguments;

        ArgumentsHolder(LinkedHashMap<String, LuaKeyArgument> name2keyArguments, LinkedHashMap<String, LuaValueArgument> name2valueArguments) {
            this.name2keyArguments = name2keyArguments;
            this.name2valueArguments = name2valueArguments;
        }
    }
}

