/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.jedis.utils.lua;

import java.util.Collections;
import java.util.List;
import org.yatech.jedis.utils.lua.LuaScript;
import org.yatech.jedis.utils.lua.LuaScriptConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisDataException;

class BasicLuaScript
implements LuaScript {
    private final String scriptText;
    private final LuaScriptConfig config;
    private final Object sha1Lock = new Object();
    private String scriptSha1;

    BasicLuaScript(String scriptText, LuaScriptConfig config) {
        this.config = config == null ? LuaScriptConfig.DEFAULT : config;
        this.scriptText = scriptText;
    }

    @Override
    public Object exec(Jedis jedis) {
        return this.exec(jedis, Collections.emptyList(), Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object exec(Jedis jedis, List<String> keys, List<String> argv) {
        block7: {
            if (!this.config.isUseScriptCaching()) {
                return jedis.eval(this.scriptText, keys, argv);
            }
            if (this.scriptSha1 != null) {
                try {
                    return jedis.evalsha(this.scriptSha1, keys, argv);
                }
                catch (RuntimeException e) {
                    if (this.isNoScriptException(e)) break block7;
                    throw e;
                }
            }
        }
        Object object = this.sha1Lock;
        synchronized (object) {
            this.scriptSha1 = jedis.scriptLoad(this.scriptText);
        }
        return jedis.evalsha(this.scriptSha1, keys, argv);
    }

    private boolean isNoScriptException(Exception e) {
        return e instanceof JedisDataException && e.getMessage().contains("NOSCRIPT");
    }

    public String toString() {
        return this.scriptText;
    }
}

