/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.jedis.utils.lua;

import java.util.ArrayList;
import java.util.Map;
import org.yatech.jedis.utils.lua.JedisCommands;
import org.yatech.jedis.utils.lua.LuaCondition;
import org.yatech.jedis.utils.lua.LuaDoubleValueArgument;
import org.yatech.jedis.utils.lua.LuaIfStatementBuilder;
import org.yatech.jedis.utils.lua.LuaIntValueArgument;
import org.yatech.jedis.utils.lua.LuaKeyArgument;
import org.yatech.jedis.utils.lua.LuaLocal;
import org.yatech.jedis.utils.lua.LuaLocalArray;
import org.yatech.jedis.utils.lua.LuaLocalValue;
import org.yatech.jedis.utils.lua.LuaLongValueArgument;
import org.yatech.jedis.utils.lua.LuaStringValueArgument;
import org.yatech.jedis.utils.lua.LuaValue;
import org.yatech.jedis.utils.lua.LuaValueArgument;
import org.yatech.jedis.utils.lua.ast.LuaAstArg;
import org.yatech.jedis.utils.lua.ast.LuaAstExpression;
import org.yatech.jedis.utils.lua.ast.LuaAstHelper;
import org.yatech.jedis.utils.lua.ast.LuaAstLocalDeclaration;
import org.yatech.jedis.utils.lua.ast.LuaAstScript;
import org.yatech.jedis.utils.lua.ast.LuaAstStatement;
import org.yatech.jedis.utils.lua.ast.LuaAstUnpack;

public abstract class AbstractLuaScriptBuilder<BuilderType extends AbstractLuaScriptBuilder>
implements JedisCommands<BuilderType> {
    protected final LuaAstScript script = new LuaAstScript();

    protected AbstractLuaScriptBuilder() {
    }

    private BuilderType thisBuilder() {
        return (BuilderType)this;
    }

    abstract String getNextLocalName();

    abstract LuaAstArg getOrCreateArgvArgument(LuaValueArgument<?> var1);

    abstract LuaAstArg getOrCreateKeyArgument(LuaKeyArgument var1);

    void add(LuaAstStatement statement) {
        this.script.getStatements().add(statement);
    }

    private LuaAstLocalDeclaration declareNewLocal() {
        String name = this.getNextLocalName();
        return LuaAstHelper.declareLocal(name);
    }

    private LuaAstUnpack unpackArray(LuaLocalArray hash) {
        return LuaAstHelper.unpack(LuaAstHelper.local(hash.getName()));
    }

    protected <T> LuaAstExpression argument(LuaValue<T> value) {
        if (value instanceof LuaLocal) {
            return LuaAstHelper.local(((LuaLocal)value).getName());
        }
        if (value instanceof LuaKeyArgument) {
            return this.getOrCreateKeyArgument((LuaKeyArgument)value);
        }
        if (value instanceof LuaValueArgument) {
            return this.getOrCreateArgvArgument((LuaValueArgument)value);
        }
        throw new IllegalArgumentException(String.format("LuaValue of specific type $s is not expected.", value.getClass().getName()));
    }

    public static LuaKeyArgument newKeyArgument(String argName) {
        return new LuaKeyArgument(argName);
    }

    public static LuaStringValueArgument newStringValueArgument(String argName) {
        return new LuaStringValueArgument(argName);
    }

    public static LuaIntValueArgument newIntValueArgument(String argName) {
        return new LuaIntValueArgument(argName);
    }

    public static LuaLongValueArgument newLongValueArgument(String argName) {
        return new LuaLongValueArgument(argName);
    }

    public static LuaDoubleValueArgument newDoubleValueArgument(String argName) {
        return new LuaDoubleValueArgument(argName);
    }

    public LuaIfStatementBuilder<BuilderType> ifCondition(LuaCondition condition) {
        return new LuaIfStatementBuilder(this, condition);
    }

    public BuilderType assign(LuaLocal local, LuaValue value) {
        this.add(LuaAstHelper.assignment(LuaAstHelper.local(local.getName()), this.argument(value)));
        return this.thisBuilder();
    }

    public BuilderType assign(LuaLocal local, LuaLocal value) {
        this.add(LuaAstHelper.assignment(LuaAstHelper.local(local.getName()), this.argument(value)));
        return this.thisBuilder();
    }

    public BuilderType assign(LuaLocal local, int value) {
        this.add(LuaAstHelper.assignment(LuaAstHelper.local(local.getName()), (LuaAstExpression)LuaAstHelper.intValue(value)));
        return this.thisBuilder();
    }

    public BuilderType assign(LuaLocal local, long value) {
        this.add(LuaAstHelper.assignment(LuaAstHelper.local(local.getName()), (LuaAstExpression)LuaAstHelper.longValue(value)));
        return this.thisBuilder();
    }

    public BuilderType assign(LuaLocal local, double value) {
        this.add(LuaAstHelper.assignment(LuaAstHelper.local(local.getName()), (LuaAstExpression)LuaAstHelper.doubleValue(value)));
        return this.thisBuilder();
    }

    public BuilderType assign(LuaLocal local, String value) {
        this.add(LuaAstHelper.assignment(LuaAstHelper.local(local.getName()), (LuaAstExpression)LuaAstHelper.stringValue(value)));
        return this.thisBuilder();
    }

    @Override
    public BuilderType select(int index) {
        this.add(LuaAstHelper.redisCallStatement("SELECT", LuaAstHelper.arguments(LuaAstHelper.intValue(index))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType select(LuaValue<Integer> index) {
        this.add(LuaAstHelper.redisCallStatement("SELECT", LuaAstHelper.arguments(this.argument(index))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType del(String key) {
        this.add(LuaAstHelper.redisCallStatement("DEL", LuaAstHelper.arguments(LuaAstHelper.stringValue(key))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType del(LuaValue<String> key) {
        this.add(LuaAstHelper.redisCallStatement("DEL", LuaAstHelper.arguments(this.argument(key))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType expire(String key, int seconds) {
        this.add(LuaAstHelper.redisCallStatement("EXPIRE", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), LuaAstHelper.intValue(seconds))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType expire(String key, LuaValue<Integer> seconds) {
        this.add(LuaAstHelper.redisCallStatement("EXPIRE", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), this.argument(seconds))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType expire(LuaValue<String> key, int seconds) {
        this.add(LuaAstHelper.redisCallStatement("EXPIRE", LuaAstHelper.arguments(this.argument(key), LuaAstHelper.intValue(seconds))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType expire(LuaValue<String> key, LuaValue<Integer> seconds) {
        this.add(LuaAstHelper.redisCallStatement("EXPIRE", LuaAstHelper.arguments(this.argument(key), this.argument(seconds))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType expireAt(String key, long timestamp) {
        this.add(LuaAstHelper.redisCallStatement("EXPIREAT", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), LuaAstHelper.longValue(timestamp))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType expireAt(String key, LuaValue<Long> timestamp) {
        this.add(LuaAstHelper.redisCallStatement("EXPIREAT", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), this.argument(timestamp))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType expireAt(LuaValue<String> key, long timestamp) {
        this.add(LuaAstHelper.redisCallStatement("EXPIREAT", LuaAstHelper.arguments(this.argument(key), LuaAstHelper.longValue(timestamp))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType expireAt(LuaValue<String> key, LuaValue<Long> timestamp) {
        this.add(LuaAstHelper.redisCallStatement("EXPIREAT", LuaAstHelper.arguments(this.argument(key), this.argument(timestamp))));
        return this.thisBuilder();
    }

    @Override
    public LuaLocalArray keys(String pattern) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("KEYS", LuaAstHelper.arguments(LuaAstHelper.stringValue(pattern)))));
        return new LuaLocalArray(local.getName());
    }

    @Override
    public LuaLocalArray keys(LuaValue<String> pattern) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("KEYS", LuaAstHelper.arguments(this.argument(pattern)))));
        return new LuaLocalArray(local.getName());
    }

    @Override
    public BuilderType move(String key, int db) {
        this.add(LuaAstHelper.redisCallStatement("MOVE", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), LuaAstHelper.intValue(db))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType move(String key, LuaValue<Integer> db) {
        this.add(LuaAstHelper.redisCallStatement("MOVE", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), this.argument(db))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType move(LuaValue<String> key, int db) {
        this.add(LuaAstHelper.redisCallStatement("MOVE", LuaAstHelper.arguments(this.argument(key), LuaAstHelper.intValue(db))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType move(LuaValue<String> key, LuaValue<Integer> db) {
        this.add(LuaAstHelper.redisCallStatement("MOVE", LuaAstHelper.arguments(this.argument(key), this.argument(db))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType persist(String key) {
        this.add(LuaAstHelper.redisCallStatement("PERSIST", LuaAstHelper.arguments(LuaAstHelper.stringValue(key))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType persist(LuaValue<String> key) {
        this.add(LuaAstHelper.redisCallStatement("PERSIST", LuaAstHelper.arguments(this.argument(key))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType pexpire(String key, long milliseconds) {
        this.add(LuaAstHelper.redisCallStatement("PEXPIRE", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), LuaAstHelper.longValue(milliseconds))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType pexpire(String key, LuaValue<Long> milliseconds) {
        this.add(LuaAstHelper.redisCallStatement("PEXPIRE", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), this.argument(milliseconds))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType pexpire(LuaValue<String> key, long milliseconds) {
        this.add(LuaAstHelper.redisCallStatement("PEXPIRE", LuaAstHelper.arguments(this.argument(key), LuaAstHelper.longValue(milliseconds))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType pexpire(LuaValue<String> key, LuaValue<Long> milliseconds) {
        this.add(LuaAstHelper.redisCallStatement("PEXPIRE", LuaAstHelper.arguments(this.argument(key), this.argument(milliseconds))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType pexpireAt(String key, long timestamp) {
        this.add(LuaAstHelper.redisCallStatement("PEXPIREAT", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), LuaAstHelper.longValue(timestamp))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType pexpireAt(String key, LuaValue<Long> timestamp) {
        this.add(LuaAstHelper.redisCallStatement("PEXPIREAT", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), this.argument(timestamp))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType pexpireAt(LuaValue<String> key, long timestamp) {
        this.add(LuaAstHelper.redisCallStatement("PEXPIREAT", LuaAstHelper.arguments(this.argument(key), LuaAstHelper.longValue(timestamp))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType pexpireAt(LuaValue<String> key, LuaValue<Long> timestamp) {
        this.add(LuaAstHelper.redisCallStatement("PEXPIREAT", LuaAstHelper.arguments(this.argument(key), this.argument(timestamp))));
        return this.thisBuilder();
    }

    @Override
    public LuaLocalValue pttl(String key) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("PTTL", LuaAstHelper.arguments(LuaAstHelper.stringValue(key)))));
        return new LuaLocalValue(local.getName());
    }

    @Override
    public LuaLocalValue pttl(LuaValue<String> key) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("PTTL", LuaAstHelper.arguments(this.argument(key)))));
        return new LuaLocalValue(local.getName());
    }

    @Override
    public LuaLocalValue randomKey() {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("RANDOMKEY", LuaAstHelper.arguments(new LuaAstExpression[0]))));
        return new LuaLocalValue(local.getName());
    }

    @Override
    public BuilderType rename(String key, String newKey) {
        this.add(LuaAstHelper.redisCallStatement("RENAME", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), LuaAstHelper.stringValue(newKey))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType rename(String key, LuaValue<String> newKey) {
        this.add(LuaAstHelper.redisCallStatement("RENAME", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), this.argument(newKey))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType rename(LuaValue<String> key, String newKey) {
        this.add(LuaAstHelper.redisCallStatement("RENAME", LuaAstHelper.arguments(this.argument(key), LuaAstHelper.stringValue(newKey))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType rename(LuaValue<String> key, LuaValue<String> newKey) {
        this.add(LuaAstHelper.redisCallStatement("RENAME", LuaAstHelper.arguments(this.argument(key), this.argument(newKey))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType renamenx(String key, String newKey) {
        this.add(LuaAstHelper.redisCallStatement("RENAMENX", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), LuaAstHelper.stringValue(newKey))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType renamenx(String key, LuaValue<String> newKey) {
        this.add(LuaAstHelper.redisCallStatement("RENAMENX", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), this.argument(newKey))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType renamenx(LuaValue<String> key, String newKey) {
        this.add(LuaAstHelper.redisCallStatement("RENAMENX", LuaAstHelper.arguments(this.argument(key), LuaAstHelper.stringValue(newKey))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType renamenx(LuaValue<String> key, LuaValue<String> newKey) {
        this.add(LuaAstHelper.redisCallStatement("RENAMENX", LuaAstHelper.arguments(this.argument(key), this.argument(newKey))));
        return this.thisBuilder();
    }

    @Override
    public LuaLocalValue ttl(String key) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("TTL", LuaAstHelper.arguments(LuaAstHelper.stringValue(key)))));
        return new LuaLocalValue(local.getName());
    }

    @Override
    public LuaLocalValue ttl(LuaValue<String> key) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("TTL", LuaAstHelper.arguments(this.argument(key)))));
        return new LuaLocalValue(local.getName());
    }

    @Override
    public LuaLocalValue type(String key) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("TYPE", LuaAstHelper.arguments(LuaAstHelper.stringValue(key)))));
        return new LuaLocalValue(local.getName());
    }

    @Override
    public LuaLocalValue type(LuaValue<String> key) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("TYPE", LuaAstHelper.arguments(this.argument(key)))));
        return new LuaLocalValue(local.getName());
    }

    @Override
    public BuilderType hdel(String key, String field, String ... moreFields) {
        ArrayList<LuaAstExpression> arguments = new ArrayList<LuaAstExpression>();
        arguments.add(LuaAstHelper.stringValue(key));
        arguments.add(LuaAstHelper.stringValue(field));
        for (String f : moreFields) {
            arguments.add(LuaAstHelper.stringValue(f));
        }
        this.add(LuaAstHelper.redisCallStatement("HDEL", arguments));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hdel(String key, LuaValue<String> field, LuaValue<String> ... moreFields) {
        ArrayList<LuaAstExpression> arguments = new ArrayList<LuaAstExpression>();
        arguments.add(LuaAstHelper.stringValue(key));
        arguments.add(this.argument(field));
        for (LuaValue<String> f : moreFields) {
            arguments.add(this.argument(f));
        }
        this.add(LuaAstHelper.redisCallStatement("HDEL", arguments));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hdel(LuaValue<String> key, String field, String ... moreFields) {
        ArrayList<LuaAstExpression> arguments = new ArrayList<LuaAstExpression>();
        arguments.add(this.argument(key));
        arguments.add(LuaAstHelper.stringValue(field));
        for (String f : moreFields) {
            arguments.add(LuaAstHelper.stringValue(f));
        }
        this.add(LuaAstHelper.redisCallStatement("HDEL", arguments));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hdel(LuaValue<String> key, LuaValue<String> field, LuaValue<String> ... moreFields) {
        ArrayList<LuaAstExpression> arguments = new ArrayList<LuaAstExpression>();
        arguments.add(this.argument(key));
        arguments.add(this.argument(field));
        for (LuaValue<String> f : moreFields) {
            arguments.add(this.argument(f));
        }
        this.add(LuaAstHelper.redisCallStatement("HDEL", arguments));
        return this.thisBuilder();
    }

    @Override
    public LuaLocalValue hget(String key, String field) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("HGET", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), LuaAstHelper.stringValue(field)))));
        return new LuaLocalValue(local.getName());
    }

    @Override
    public LuaLocalValue hget(String key, LuaValue<String> field) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("HGET", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), this.argument(field)))));
        return new LuaLocalValue(local.getName());
    }

    @Override
    public LuaLocalValue hget(LuaValue<String> key, String field) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("HGET", LuaAstHelper.arguments(this.argument(key), LuaAstHelper.stringValue(field)))));
        return new LuaLocalValue(local.getName());
    }

    @Override
    public LuaLocalValue hget(LuaValue<String> key, LuaValue<String> field) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("HGET", LuaAstHelper.arguments(this.argument(key), this.argument(field)))));
        return new LuaLocalValue(local.getName());
    }

    @Override
    public LuaLocalArray hgetAll(String key) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("HGETALL", LuaAstHelper.arguments(LuaAstHelper.stringValue(key)))));
        return new LuaLocalArray(local.getName());
    }

    @Override
    public LuaLocalArray hgetAll(LuaValue<String> key) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("HGETALL", LuaAstHelper.arguments(this.argument(key)))));
        return new LuaLocalArray(local.getName());
    }

    @Override
    public BuilderType hincrBy(String key, String field, long increment) {
        this.add(LuaAstHelper.redisCallStatement("HINCRBY", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), LuaAstHelper.stringValue(field), LuaAstHelper.longValue(increment))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hincrBy(String key, String field, LuaValue<Long> increment) {
        this.add(LuaAstHelper.redisCallStatement("HINCRBY", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), LuaAstHelper.stringValue(field), this.argument(increment))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hincrBy(String key, LuaValue<String> field, long increment) {
        this.add(LuaAstHelper.redisCallStatement("HINCRBY", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), this.argument(field), LuaAstHelper.longValue(increment))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hincrBy(String key, LuaValue<String> field, LuaValue<Long> increment) {
        this.add(LuaAstHelper.redisCallStatement("HINCRBY", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), this.argument(field), this.argument(increment))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hincrBy(LuaValue<String> key, String field, long increment) {
        this.add(LuaAstHelper.redisCallStatement("HINCRBY", LuaAstHelper.arguments(this.argument(key), LuaAstHelper.stringValue(field), LuaAstHelper.longValue(increment))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hincrBy(LuaValue<String> key, String field, LuaValue<Long> increment) {
        this.add(LuaAstHelper.redisCallStatement("HINCRBY", LuaAstHelper.arguments(this.argument(key), LuaAstHelper.stringValue(field), this.argument(increment))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hincrBy(LuaValue<String> key, LuaValue<String> field, long increment) {
        this.add(LuaAstHelper.redisCallStatement("HINCRBY", LuaAstHelper.arguments(this.argument(key), this.argument(field), LuaAstHelper.longValue(increment))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hincrBy(LuaValue<String> key, LuaValue<String> field, LuaValue<Long> increment) {
        this.add(LuaAstHelper.redisCallStatement("HINCRBY", LuaAstHelper.arguments(this.argument(key), this.argument(field), this.argument(increment))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hincrByFloat(String key, String field, double increment) {
        this.add(LuaAstHelper.redisCallStatement("HINCRBYFLOAT", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), LuaAstHelper.stringValue(field), LuaAstHelper.doubleValue(increment))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hincrByFloat(String key, String field, LuaValue<Double> increment) {
        this.add(LuaAstHelper.redisCallStatement("HINCRBYFLOAT", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), LuaAstHelper.stringValue(field), this.argument(increment))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hincrByFloat(String key, LuaValue<String> field, double increment) {
        this.add(LuaAstHelper.redisCallStatement("HINCRBYFLOAT", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), this.argument(field), LuaAstHelper.doubleValue(increment))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hincrByFloat(String key, LuaValue<String> field, LuaValue<Double> increment) {
        this.add(LuaAstHelper.redisCallStatement("HINCRBYFLOAT", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), this.argument(field), this.argument(increment))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hincrByFloat(LuaValue<String> key, String field, double increment) {
        this.add(LuaAstHelper.redisCallStatement("HINCRBYFLOAT", LuaAstHelper.arguments(this.argument(key), LuaAstHelper.stringValue(field), LuaAstHelper.doubleValue(increment))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hincrByFloat(LuaValue<String> key, String field, LuaValue<Double> increment) {
        this.add(LuaAstHelper.redisCallStatement("HINCRBYFLOAT", LuaAstHelper.arguments(this.argument(key), LuaAstHelper.stringValue(field), this.argument(increment))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hincrByFloat(LuaValue<String> key, LuaValue<String> field, double increment) {
        this.add(LuaAstHelper.redisCallStatement("HINCRBYFLOAT", LuaAstHelper.arguments(this.argument(key), this.argument(field), LuaAstHelper.doubleValue(increment))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hincrByFloat(LuaValue<String> key, LuaValue<String> field, LuaValue<Double> increment) {
        this.add(LuaAstHelper.redisCallStatement("HINCRBYFLOAT", LuaAstHelper.arguments(this.argument(key), this.argument(field), this.argument(increment))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hmset(String key, Map<String, String> hash) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public BuilderType hmset(LuaValue<String> key, Map<String, String> hash) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public BuilderType hmset(String key, LuaLocalArray hash) {
        this.add(LuaAstHelper.redisCallStatement("HMSET", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), this.unpackArray(hash))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType hmset(LuaValue<String> key, LuaLocalArray hash) {
        this.add(LuaAstHelper.redisCallStatement("HMSET", LuaAstHelper.arguments(this.argument(key), this.unpackArray(hash))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType set(String key, String value) {
        this.add(LuaAstHelper.redisCallStatement("SET", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), LuaAstHelper.stringValue(value))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType set(String key, LuaValue<String> value) {
        this.add(LuaAstHelper.redisCallStatement("SET", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), this.argument(value))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType set(LuaValue<String> key, String value) {
        this.add(LuaAstHelper.redisCallStatement("SET", LuaAstHelper.arguments(this.argument(key), LuaAstHelper.stringValue(value))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType set(LuaValue<String> key, LuaValue<String> value) {
        this.add(LuaAstHelper.redisCallStatement("SET", LuaAstHelper.arguments(this.argument(key), this.argument(value))));
        return this.thisBuilder();
    }

    @Override
    public LuaLocalValue get(String key) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("GET", LuaAstHelper.arguments(LuaAstHelper.stringValue(key)))));
        return new LuaLocalValue(local.getName());
    }

    @Override
    public LuaLocalValue get(LuaValue<String> key) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("GET", LuaAstHelper.arguments(this.argument(key)))));
        return new LuaLocalValue(local.getName());
    }

    @Override
    public BuilderType zadd(String key, double score, String member) {
        this.add(LuaAstHelper.redisCallStatement("ZADD", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), LuaAstHelper.doubleValue(score), LuaAstHelper.stringValue(member))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType zadd(String key, double score, LuaValue<String> member) {
        this.add(LuaAstHelper.redisCallStatement("ZADD", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), LuaAstHelper.doubleValue(score), this.argument(member))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType zadd(String key, LuaValue<Double> score, String member) {
        this.add(LuaAstHelper.redisCallStatement("ZADD", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), this.argument(score), LuaAstHelper.stringValue(member))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType zadd(String key, LuaValue<Double> score, LuaValue<String> member) {
        this.add(LuaAstHelper.redisCallStatement("ZADD", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), this.argument(score), this.argument(member))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType zadd(LuaValue<String> key, double score, String member) {
        this.add(LuaAstHelper.redisCallStatement("ZADD", LuaAstHelper.arguments(this.argument(key), LuaAstHelper.doubleValue(score), LuaAstHelper.stringValue(member))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType zadd(LuaValue<String> key, double score, LuaValue<String> member) {
        this.add(LuaAstHelper.redisCallStatement("ZADD", LuaAstHelper.arguments(this.argument(key), LuaAstHelper.doubleValue(score), this.argument(member))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType zadd(LuaValue<String> key, LuaValue<Double> score, String member) {
        this.add(LuaAstHelper.redisCallStatement("ZADD", LuaAstHelper.arguments(this.argument(key), this.argument(score), LuaAstHelper.stringValue(member))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType zadd(LuaValue<String> key, LuaValue<Double> score, LuaValue<String> member) {
        this.add(LuaAstHelper.redisCallStatement("ZADD", LuaAstHelper.arguments(this.argument(key), this.argument(score), this.argument(member))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType zadd(String key, Map<String, Double> scoreMembers) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public BuilderType zadd(LuaValue<String> key, Map<String, Double> scoreMembers) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public BuilderType zadd(String key, LuaLocalArray scoreMembers) {
        this.add(LuaAstHelper.redisCallStatement("ZADD", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), this.unpackArray(scoreMembers))));
        return this.thisBuilder();
    }

    @Override
    public BuilderType zadd(LuaValue<String> key, LuaLocalArray scoreMembers) {
        this.add(LuaAstHelper.redisCallStatement("ZADD", LuaAstHelper.arguments(this.argument(key), this.unpackArray(scoreMembers))));
        return this.thisBuilder();
    }

    @Override
    public LuaLocalValue zscore(String key, String member) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("ZSCORE", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), LuaAstHelper.stringValue(member)))));
        return new LuaLocalValue(local.getName());
    }

    @Override
    public LuaLocalValue zscore(LuaValue<String> key, String member) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("ZSCORE", LuaAstHelper.arguments(this.argument(key), LuaAstHelper.stringValue(member)))));
        return new LuaLocalValue(local.getName());
    }

    @Override
    public LuaLocalValue zscore(String key, LuaValue<String> member) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("ZSCORE", LuaAstHelper.arguments(LuaAstHelper.stringValue(key), this.argument(member)))));
        return new LuaLocalValue(local.getName());
    }

    @Override
    public LuaLocalValue zscore(LuaValue<String> key, LuaValue<String> member) {
        LuaAstLocalDeclaration local = this.declareNewLocal();
        this.add(LuaAstHelper.assignment(local, (LuaAstExpression)LuaAstHelper.redisCall("ZSCORE", LuaAstHelper.arguments(this.argument(key), this.argument(member)))));
        return new LuaLocalValue(local.getName());
    }
}

