/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.jedis.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.yatech.jedis.collections.Utils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public class JedisKeysScanner
implements Iterator<String> {
    private static final String FIRST_CURSOR = "0";
    private static final int DB_NA = -1;
    private final Jedis jedis;
    private final JedisPool jedisPool;
    private final int db;
    private final ScanParams scanParams;
    private ScanResult scanResult;
    private int resultIndex;

    public JedisKeysScanner(Jedis jedis) {
        this(jedis, new ScanParams());
    }

    public JedisKeysScanner(Jedis jedis, ScanParams scanParams) {
        this(Utils.checkNotNull(jedis, "jedis"), null, -1, scanParams);
    }

    public JedisKeysScanner(JedisPool jedisPool, int db) {
        this(jedisPool, db, new ScanParams());
    }

    public JedisKeysScanner(JedisPool jedisPool, int db, ScanParams scanParams) {
        this(null, Utils.checkNotNull(jedisPool, "jedisPool"), Utils.checkNotNegative(db, "db"), scanParams);
    }

    private JedisKeysScanner(Jedis jedis, JedisPool jedisPool, int db, ScanParams scanParams) {
        this.checkConstructorParams(jedis, jedisPool, db, scanParams);
        this.jedis = jedis;
        this.jedisPool = jedisPool;
        this.db = db;
        this.scanParams = scanParams;
        this.init();
    }

    private void checkConstructorParams(Jedis jedis, JedisPool jedisPool, int db, ScanParams scanParams) {
        if (jedis == null && jedisPool == null) {
            throw new IllegalArgumentException("One of jedis or jedis pool is required");
        }
        if (jedisPool != null) {
            if (jedis != null) {
                throw new IllegalArgumentException("Only one of jedis or jedis pool can be given");
            }
            Utils.checkTrue(db >= 0, "db", "A non-negative DB index is required when using a jedis pool");
        }
        Utils.checkNotNull(scanParams, "scanParams");
    }

    private void init() {
        this.scanResult = this.scan(FIRST_CURSOR, this.scanParams);
        this.resultIndex = 0;
        this.ensureNext();
    }

    private ScanResult scan(String cursor, ScanParams scanParams) {
        if (this.jedis != null) {
            return this.jedis.scan(cursor, scanParams);
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db);
            ScanResult scanResult = jedis.scan(cursor, scanParams);
            return scanResult;
        }
    }

    @Override
    public boolean hasNext() {
        return this.scanResult != null && (!FIRST_CURSOR.equals(this.scanResult.getStringCursor()) || this.resultIndex < this.scanResult.getResult().size());
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String key = (String)this.scanResult.getResult().get(this.resultIndex++);
        this.ensureNext();
        return key;
    }

    private void ensureNext() {
        if (this.resultIndex < this.scanResult.getResult().size()) {
            return;
        }
        if (!FIRST_CURSOR.equals(this.scanResult.getStringCursor())) {
            this.scanResult = this.scan(this.scanResult.getStringCursor(), this.scanParams);
            this.resultIndex = 0;
            this.ensureNext();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported");
    }
}

