/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.jedis.collections;

import org.yatech.jedis.collections.JedisCallable;
import org.yatech.jedis.collections.Utils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public abstract class JedisCollectionBase {
    private static final int DB_NA = -1;
    private final JedisPool jedisPool;
    private final Jedis jedis;
    private final String key;
    private final int db;

    JedisCollectionBase(JedisPool jedisPool, int db, String key) {
        this.jedisPool = Utils.checkNotNull(jedisPool, "jedisPool");
        this.jedis = null;
        this.db = Utils.checkNotNegative(db, "db");
        this.key = Utils.checkNotNull(key, "key");
    }

    JedisCollectionBase(Jedis jedis, String key) {
        this.jedisPool = null;
        this.jedis = Utils.checkNotNull(jedis, "jedis");
        this.db = -1;
        this.key = Utils.checkNotNull(key, "key");
    }

    protected String getKey() {
        return this.key;
    }

    <T> T doWithJedis(JedisCallable<T> callable) {
        if (this.jedis != null) {
            return callable.call(this.jedis);
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.select(this.db);
            T t = callable.call(jedis);
            return t;
        }
    }
}

