/*
 * Decompiled with CFR 0.152.
 */
package org.yamj.api.common.http;

import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;

public class SimpleHttpClientBuilder {
    private int maxConnTotal = 20;
    private int maxConnPerRoute = 1;
    private boolean systemProperties = false;
    private int connectionRequestTimeout = 15000;
    private int connectTimeout = 25000;
    private int socketTimeout = 90000;
    private String proxyHost;
    private int proxyPort = 0;
    private String proxyUsername;
    private String proxyPassword;

    public SimpleHttpClientBuilder setMaxConnTotal(int maxConnTotal) {
        this.maxConnTotal = maxConnTotal;
        return this;
    }

    public SimpleHttpClientBuilder setMaxConnPerRoute(int maxConnPerRoute) {
        this.maxConnPerRoute = maxConnPerRoute;
        return this;
    }

    public SimpleHttpClientBuilder setSystemProperties(boolean systemProperties) {
        this.systemProperties = systemProperties;
        return this;
    }

    public SimpleHttpClientBuilder setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
        return this;
    }

    public SimpleHttpClientBuilder setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public SimpleHttpClientBuilder setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public SimpleHttpClientBuilder setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public SimpleHttpClientBuilder setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public SimpleHttpClientBuilder setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
        return this;
    }

    public SimpleHttpClientBuilder setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return this;
    }

    public CloseableHttpClient build() {
        HttpHost proxy = null;
        Object credentialsProvider = null;
        if (SimpleHttpClientBuilder.isNotBlank(this.proxyHost) && this.proxyPort > 0) {
            proxy = new HttpHost(this.proxyHost, this.proxyPort);
            if (SimpleHttpClientBuilder.isNotBlank(this.proxyUsername) && SimpleHttpClientBuilder.isNotBlank(this.proxyPassword)) {
                credentialsProvider = this.systemProperties ? new SystemDefaultCredentialsProvider() : new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(this.proxyHost, this.proxyPort), (Credentials)new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword));
            }
        }
        HttpClientBuilder builder = HttpClientBuilder.create().setMaxConnTotal(this.maxConnTotal).setMaxConnPerRoute(this.maxConnPerRoute).setProxy(proxy).setDefaultCredentialsProvider(credentialsProvider).setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(this.connectionRequestTimeout).setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).setProxy(proxy).build());
        if (this.systemProperties) {
            builder.useSystemProperties();
        }
        return builder.build();
    }

    private static boolean isNotBlank(String test) {
        return test != null && !test.isEmpty();
    }
}

