/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml.wikimodel;

import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.internal.parser.xhtml.XHTMLParser;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiMacroHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiWikiModelHandler;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.xhtml.handler.SpanTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagContext;

public class XWikiSpanTagHandler
extends SpanTagHandler
implements XWikiWikiModelHandler {
    private static final Set<String> IGNORED_CLASSES = Set.of("wikilink", "wikiinternallink", "wikicreatelink", "wikiexternallink", "wikiattachmentlink");
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String WIKI_GENERATED_LINK_CONTENT = "wikigeneratedlinkcontent";
    private static final String XWIKI_RENDERING_ERROR = "xwikirenderingerror";
    private XWikiMacroHandler xWikiMacroHandler;

    public XWikiSpanTagHandler(ComponentManager componentManager, XHTMLParser parser) {
        this.xWikiMacroHandler = new XWikiMacroHandler(componentManager, parser);
    }

    protected void begin(TagContext context) {
        WikiParameters params = context.getParams();
        boolean withNonGeneratedContent = this.xWikiMacroHandler.handleBegin(context);
        if (!withNonGeneratedContent) {
            WikiParameter classParam = params.getParameter(CLASS_ATTRIBUTE);
            if (classParam != null) {
                String classParamValue = classParam.getValue();
                String filteredClassNames = XWikiSpanTagHandler.filterIgnoredClasses(classParamValue);
                if (classParamValue.contains(WIKI_GENERATED_LINK_CONTENT) || XWIKI_RENDERING_ERROR.equals(classParamValue)) {
                    this.setAccumulateContent(true);
                } else if (filteredClassNames.equals(classParamValue)) {
                    super.begin(context);
                } else if (!filteredClassNames.isEmpty()) {
                    super.begin(XWikiSpanTagHandler.updateContext(context, filteredClassNames));
                }
            } else {
                super.begin(context);
            }
        }
    }

    protected void end(TagContext context) {
        boolean nonGeneratedContent = this.xWikiMacroHandler.handleEnd(context);
        if (!nonGeneratedContent) {
            WikiParameter classParam = context.getParams().getParameter(CLASS_ATTRIBUTE);
            if (classParam != null) {
                String classParamValue = classParam.getValue();
                String filteredClassNames = XWikiSpanTagHandler.filterIgnoredClasses(classParamValue);
                if (classParamValue.contains(WIKI_GENERATED_LINK_CONTENT) || XWIKI_RENDERING_ERROR.equals(classParamValue)) {
                    this.setAccumulateContent(false);
                } else if (filteredClassNames.equals(classParamValue)) {
                    super.end(context);
                } else if (!filteredClassNames.isEmpty()) {
                    super.end(XWikiSpanTagHandler.updateContext(context, filteredClassNames));
                }
            } else {
                super.end(context);
            }
        }
    }

    private static TagContext updateContext(TagContext context, String filteredClassNames) {
        WikiParameters updatedParameters = context.getParams().setParameter(CLASS_ATTRIBUTE, filteredClassNames);
        return new TagContext(context.getParentContext(), context.getName(), updatedParameters, context.getTagStack());
    }

    private static String filterIgnoredClasses(String classParamValue) {
        String[] classes = StringUtils.split((String)classParamValue);
        String filteredClassNames = Arrays.stream(classes).anyMatch(IGNORED_CLASSES::contains) ? Arrays.stream(classes).filter(Predicate.not(IGNORED_CLASSES::contains)).collect(Collectors.joining(" ")) : classParamValue;
        return filteredClassNames;
    }
}

