/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml.wikimodel;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.parser.wikimodel.DefaultXWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiWikiReference;
import org.xwiki.rendering.listener.InlineFilterListener;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.util.IdGenerator;
import org.xwiki.rendering.wikimodel.WikiFormat;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiReference;

public class XHTMLXWikiGeneratorListener
extends DefaultXWikiGeneratorListener {
    public static final String METADATA_CONTAINER_CLASS = "xwiki-metadata-container";
    public static final String METADATA_ATTRIBUTE_PREFIX = "data-xwiki-";
    private static final String CLASS_ATTRIBUTE = "class";

    public XHTMLXWikiGeneratorListener(StreamParser parser, Listener listener, ResourceReferenceParser linkReferenceParser, ResourceReferenceParser imageReferenceParser, PrintRendererFactory plainRendererFactory, IdGenerator idGenerator, Syntax syntax) {
        super(parser, listener, linkReferenceParser, imageReferenceParser, plainRendererFactory, idGenerator, syntax);
    }

    public void onReference(WikiReference reference) {
        if (!(reference instanceof XWikiWikiReference)) {
            throw new IllegalArgumentException("Expected XWikiWikiReference but got another type!");
        }
        XWikiWikiReference xwikiReference = (XWikiWikiReference)reference;
        ResourceReference resourceReference = xwikiReference.getReference();
        boolean isFreeStanding = xwikiReference.isFreeStanding();
        XDOM labelXDOM = xwikiReference.getLabelXDOM();
        this.flushFormat();
        Pair parameters = this.convertAndSeparateParameters(reference.getParameters());
        resourceReference.setParameters((Map)parameters.getLeft());
        this.getListener().beginLink(resourceReference, isFreeStanding, (Map)parameters.getRight());
        if (labelXDOM != null) {
            InlineFilterListener inlineFilterListener = new InlineFilterListener();
            inlineFilterListener.setWrappedListener(this.getListener());
            labelXDOM.traverse((Listener)inlineFilterListener);
        }
        this.getListener().endLink(resourceReference, isFreeStanding, (Map)parameters.getRight());
    }

    public void onImage(WikiReference reference) {
        if (!(reference instanceof XWikiWikiReference)) {
            super.onImage(reference);
        } else {
            XWikiWikiReference xwikiReference = (XWikiWikiReference)reference;
            ResourceReference resourceReference = xwikiReference.getReference();
            this.flushFormat();
            this.onImage(resourceReference, xwikiReference.isFreeStanding(), this.convertParameters(xwikiReference.getParameters()));
        }
    }

    static boolean isMetaDataElement(WikiParameters parameters) {
        return parameters.getParameter(CLASS_ATTRIBUTE) != null && ArrayUtils.contains((Object[])StringUtils.split((String)parameters.getParameter(CLASS_ATTRIBUTE).getValue()), (Object)METADATA_CONTAINER_CLASS);
    }

    static MetaData createMetaData(WikiParameters parameters) {
        MetaData metaData = new MetaData();
        int prefixSize = METADATA_ATTRIBUTE_PREFIX.length();
        for (WikiParameter parameter : parameters) {
            if (!parameter.getKey().startsWith(METADATA_ATTRIBUTE_PREFIX)) continue;
            String metaDataKey = parameter.getKey().substring(prefixSize).toLowerCase();
            metaData.addMetaData(metaDataKey, (Object)parameter.getValue());
        }
        return metaData;
    }

    private static WikiParameters cleanParametersFromMetadata(WikiParameters parameters) {
        WikiParameters wikiParameters = new WikiParameters();
        for (WikiParameter parameter : parameters) {
            boolean acceptParameter = !parameter.getKey().startsWith(METADATA_ATTRIBUTE_PREFIX);
            String value = parameter.getValue();
            if (CLASS_ATTRIBUTE.equals(parameter.getKey())) {
                value = Arrays.stream(StringUtils.split((String)value)).filter(Predicate.not(METADATA_CONTAINER_CLASS::equals)).collect(Collectors.joining(" "));
                acceptParameter = StringUtils.isNotBlank((CharSequence)value);
            }
            if (!acceptParameter) continue;
            wikiParameters = wikiParameters.addParameter(parameter.getKey(), value);
        }
        return wikiParameters;
    }

    protected void beginGroup(WikiParameters parameters) {
        if (XHTMLXWikiGeneratorListener.isMetaDataElement(parameters)) {
            MetaData metaData = XHTMLXWikiGeneratorListener.createMetaData(parameters);
            this.getListener().beginMetaData(metaData);
            WikiParameters cleanParameters = XHTMLXWikiGeneratorListener.cleanParametersFromMetadata(parameters);
            if (cleanParameters.getSize() > 0) {
                super.beginGroup(cleanParameters);
            }
        } else {
            super.beginGroup(parameters);
        }
    }

    protected void endGroup(WikiParameters parameters) {
        if (XHTMLXWikiGeneratorListener.isMetaDataElement(parameters)) {
            MetaData metaData = XHTMLXWikiGeneratorListener.createMetaData(parameters);
            this.getListener().endMetaData(metaData);
            WikiParameters cleanParameters = XHTMLXWikiGeneratorListener.cleanParametersFromMetadata(parameters);
            if (cleanParameters.getSize() > 0) {
                super.endGroup(cleanParameters);
            }
        } else {
            super.endGroup(parameters);
        }
    }

    public void beginFormat(WikiFormat format) {
        WikiParameters wikiParameters = new WikiParameters((Collection)format.getParams());
        if (XHTMLXWikiGeneratorListener.isMetaDataElement(wikiParameters)) {
            this.getListener().beginMetaData(XHTMLXWikiGeneratorListener.createMetaData(wikiParameters));
            WikiParameters cleanParameters = XHTMLXWikiGeneratorListener.cleanParametersFromMetadata(wikiParameters);
            if (cleanParameters.getSize() > 0 || !format.getStyles().isEmpty()) {
                WikiFormat newFormat = format;
                if (wikiParameters.getSize() != cleanParameters.getSize()) {
                    newFormat = format.setParameters((Collection)cleanParameters.toList());
                }
                super.beginFormat(newFormat);
            }
        } else {
            super.beginFormat(format);
        }
    }

    public void endFormat(WikiFormat format) {
        WikiParameters wikiParameters = new WikiParameters((Collection)format.getParams());
        if (XHTMLXWikiGeneratorListener.isMetaDataElement(wikiParameters)) {
            this.getListener().endMetaData(XHTMLXWikiGeneratorListener.createMetaData(wikiParameters));
            WikiParameters cleanParameters = XHTMLXWikiGeneratorListener.cleanParametersFromMetadata(wikiParameters);
            if (cleanParameters.getSize() > 0 || !format.getStyles().isEmpty()) {
                WikiFormat newFormat = format;
                if (wikiParameters.getSize() != cleanParameters.getSize()) {
                    newFormat = format.setParameters((Collection)cleanParameters.toList());
                }
                super.endFormat(newFormat);
            }
        } else {
            super.endFormat(format);
        }
    }
}

