/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.xdomxml.internal.version10.renderer;

import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;
import org.xwiki.rendering.internal.renderer.xml.AbstractChainingContentHandlerStreamRenderer;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.xdomxml.internal.current.parameter.ParameterManager;
import org.xwiki.rendering.xdomxml.internal.renderer.parameters.DefaultSerializer;
import org.xwiki.rendering.xdomxml.internal.version10.renderer.parameter.FormatConverter;
import org.xwiki.rendering.xdomxml.internal.version10.renderer.parameter.HeaderLevelConverter;
import org.xwiki.rendering.xdomxml.internal.version10.renderer.parameter.ListTypeConverter;
import org.xwiki.rendering.xdomxml.internal.version10.renderer.parameter.ResourceReferenceSerializer;

public class XDOMXMLChainingStreamRenderer
extends AbstractChainingContentHandlerStreamRenderer {
    private static final DefaultSerializer SERIALIZER = new DefaultSerializer();
    private static final String VERSION = "1.0";
    private FormatConverter formatConverter = new FormatConverter();
    private HeaderLevelConverter headerLevelConverter = new HeaderLevelConverter();
    private ListTypeConverter listTypeConverter = new ListTypeConverter();
    private ResourceReferenceSerializer linkSerializer = new ResourceReferenceSerializer();
    private boolean versionSerialized = false;

    public XDOMXMLChainingStreamRenderer(ListenerChain listenerChain, ParameterManager parameterManager) {
        this.setListenerChain(listenerChain);
    }

    public Syntax getSyntax() {
        return Syntax.XDOMXML_1_0;
    }

    public void beginDocument(MetaData metaData) {
        this.startBlock("document");
        if (!metaData.getMetaData().isEmpty()) {
            this.serializeParameter("metaData", metaData, false);
        }
    }

    public void beginGroup(Map<String, String> parameters) {
        this.startBlock("group", parameters);
    }

    public void beginFormat(Format format, Map<String, String> parameters) {
        this.startBlock("format", parameters);
        this.serializeParameter("format", this.formatConverter.toString(format), false);
    }

    public void beginParagraph(Map<String, String> parameters) {
        this.startBlock("paragraph", parameters);
    }

    public void beginLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.startBlock("link", parameters);
        this.linkSerializer.serialize(reference, this.getContentHandler());
        if (isFreeStandingURI) {
            this.serializeParameter("freestanding", isFreeStandingURI, false);
        }
    }

    public void beginSection(Map<String, String> parameters) {
        this.startBlock("section", parameters);
    }

    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.startBlock("header", parameters);
        this.serializeParameter("level", this.headerLevelConverter.toString(level), false);
        this.serializeParameter("id", id, false);
    }

    public void beginList(ListType listType, Map<String, String> parameters) {
        this.startBlock("list", parameters);
        this.serializeParameter("type", this.listTypeConverter.toString(listType), false);
    }

    public void beginListItem() {
        this.startBlock("listItem");
    }

    public void beginDefinitionTerm() {
        this.startBlock("definitionTerm");
    }

    public void beginDefinitionDescription() {
        this.startBlock("definitionDescription");
    }

    public void beginTable(Map<String, String> parameters) {
        this.startBlock("table", parameters);
    }

    public void beginTableCell(Map<String, String> parameters) {
        this.startBlock("tableCell", parameters);
    }

    public void beginTableHeadCell(Map<String, String> parameters) {
        this.startBlock("tableHeadCell", parameters);
    }

    public void beginTableRow(Map<String, String> parameters) {
        this.startBlock("tableRow", parameters);
    }

    public void beginQuotation(Map<String, String> parameters) {
        this.startBlock("quotation", parameters);
    }

    public void beginMacroMarker(String id, Map<String, String> parameters, String content, boolean isInline) {
        this.startBlock("macroMarker", parameters);
        this.serializeParameter("id", id, false);
        if (content != null) {
            this.serializeParameter("content", content, false);
        }
        if (isInline) {
            this.serializeParameter("inline", isInline, false);
        }
    }

    public void beginDefinitionList(Map<String, String> parameters) {
        this.startBlock("definitionList", parameters);
    }

    public void beginQuotationLine() {
        this.startBlock("quotationLine");
    }

    public void beginMetaData(MetaData metaData) {
        this.startBlock("metaData");
        if (!metaData.getMetaData().isEmpty()) {
            this.serializeParameter("metaData", metaData, false);
        }
    }

    public void endDocument(MetaData metaData) {
        this.endBlock();
    }

    public void endGroup(Map<String, String> parameters) {
        this.endBlock();
    }

    public void endFormat(Format format, Map<String, String> parameters) {
        this.endBlock();
    }

    public void endParagraph(Map<String, String> parameters) {
        this.endBlock();
    }

    public void endLink(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.endBlock();
    }

    public void endSection(Map<String, String> parameters) {
        this.endBlock();
    }

    public void endHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.endBlock();
    }

    public void endList(ListType listType, Map<String, String> parameters) {
        this.endBlock();
    }

    public void endListItem() {
        this.endBlock();
    }

    public void endMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
        this.endBlock();
    }

    public void endDefinitionList(Map<String, String> parameters) {
        this.endBlock();
    }

    public void endDefinitionTerm() {
        this.endBlock();
    }

    public void endDefinitionDescription() {
        this.endBlock();
    }

    public void endQuotation(Map<String, String> parameters) {
        this.endBlock();
    }

    public void endQuotationLine() {
        this.endBlock();
    }

    public void endTable(Map<String, String> parameters) {
        this.endBlock();
    }

    public void endTableCell(Map<String, String> parameters) {
        this.endBlock();
    }

    public void endTableHeadCell(Map<String, String> parameters) {
        this.endBlock();
    }

    public void endTableRow(Map<String, String> parameters) {
        this.endBlock();
    }

    public void endMetaData(MetaData metadata) {
        this.endBlock();
    }

    public void onNewLine() {
        this.emptyBlock("newLine");
    }

    public void onMacro(String id, Map<String, String> parameters, String content, boolean isInline) {
        this.startBlock("macro", parameters);
        this.serializeParameter("id", id, false);
        if (content != null) {
            this.serializeParameter("content", content, false);
        }
        if (isInline) {
            this.serializeParameter("inline", isInline, false);
        }
        this.endBlock();
    }

    public void onWord(String word) {
        this.startBlock("word");
        this.serializeParameter("word", word, false);
        this.endBlock();
    }

    public void onSpace() {
        this.emptyBlock("space");
    }

    public void onSpecialSymbol(char symbol) {
        this.startBlock("specialSymbol");
        this.serializeParameter("symbol", symbol, false);
        this.endBlock();
    }

    public void onRawText(String text, Syntax syntax) {
        this.startBlock("rawText");
        this.serializeParameter("content", text, false);
        this.serializeParameter("syntax", syntax.toIdString(), false);
        this.endBlock();
    }

    public void onId(String name) {
        this.startBlock("id");
        this.serializeParameter("name", name, false);
        this.endBlock();
    }

    public void onHorizontalLine(Map<String, String> parameters) {
        this.emptyBlock("horizontalLine", parameters);
    }

    public void onEmptyLines(int count) {
        this.startBlock("emptyLines");
        if (count > 1) {
            this.serializeParameter("count", count, false);
        }
        this.endBlock();
    }

    public void onVerbatim(String protectedString, boolean isInline, Map<String, String> parameters) {
        this.startBlock("verbatim");
        this.serializeParameter("content", protectedString, false);
        if (isInline) {
            this.serializeParameter("inline", isInline, false);
        }
        this.endBlock();
    }

    public void onImage(ResourceReference reference, boolean isFreeStandingURI, Map<String, String> parameters) {
        this.startBlock("image", parameters);
        this.serializeParameter("freestanding", isFreeStandingURI, false);
        this.linkSerializer.serialize(reference, this.getContentHandler());
        this.endBlock();
    }

    private void startBlock(String blockName) {
        this.startBlock(blockName, null);
    }

    private void startBlock(String blockName, Map<String, String> customParameters) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(null, null, "name", null, blockName);
        if (!this.versionSerialized) {
            attributes.addAttribute(null, null, "version", null, VERSION);
            this.versionSerialized = true;
        }
        this.startElement("block", attributes);
        if (customParameters != null) {
            this.serializeCustomParameters(customParameters);
        }
    }

    private void endBlock() {
        this.endElement("block");
    }

    private void emptyBlock(String blockName) {
        this.startBlock(blockName);
        this.endBlock();
    }

    private void emptyBlock(String blockName, Map<String, String> customParameters) {
        this.startBlock(blockName, customParameters);
        this.endBlock();
    }

    private void serializeCustomParameters(Map<String, String> parameters) {
        if (parameters.size() > 0) {
            this.serializeParameter("parameters", parameters, false);
        }
    }

    public void serializeParameter(String name, Map<?, ?> map, boolean type) {
        SERIALIZER.serializeParameter(name, map, type, this.getContentHandler());
    }

    public void serializeParameter(String name, MetaData metaData, boolean type) {
        Attributes attributes;
        if (type) {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute(null, null, "type", null, "MetaData");
            attributes = attributesImpl;
        } else {
            attributes = DefaultSerializer.EMPTY_ATTRIBUTES;
        }
        this.startElement(name, attributes);
        for (Map.Entry entry : metaData.getMetaData().entrySet()) {
            this.serializeParameter((String)entry.getKey(), entry.getValue(), true);
        }
        this.endElement(name);
    }

    public void serializeParameter(String name, boolean value, boolean type) {
        SERIALIZER.serializeParameter(name, value, type, this.getContentHandler());
    }

    public void serializeParameter(String name, char value, boolean type) {
        SERIALIZER.serializeParameter(name, value, type, this.getContentHandler());
    }

    public void serializeParameter(String name, int value, boolean type) {
        SERIALIZER.serializeParameter(name, value, type, this.getContentHandler());
    }

    public void serializeParameter(String name, String value, boolean type) {
        SERIALIZER.serializeParameter(name, value, null, this.getContentHandler());
    }

    public void serializeParameter(String name, Format value, boolean type) {
        SERIALIZER.serializeParameter(name, this.formatConverter.toString(value), type ? "Format" : null, this.getContentHandler());
    }

    public void serializeParameter(String name, HeaderLevel value, boolean type) {
        SERIALIZER.serializeParameter(name, this.headerLevelConverter.toString(value), type ? "HeaderLevel" : null, this.getContentHandler());
    }

    public void serializeParameter(String name, ListType value, boolean type) {
        SERIALIZER.serializeParameter(name, this.listTypeConverter.toString(value), type ? "ListType" : null, this.getContentHandler());
    }

    public void serializeParameter(String name, ResourceReference value, boolean type) {
        Attributes attributes;
        if (type) {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute(null, null, "type", null, "ResourceReference");
            attributes = attributesImpl;
        } else {
            attributes = DefaultSerializer.EMPTY_ATTRIBUTES;
        }
        this.startElement(name, attributes);
        this.linkSerializer.serialize(value, this.getContentHandler());
        this.endElement(name);
    }

    public void serializeParameter(String name, Number value, boolean type) {
        SERIALIZER.serializeParameter(name, value.toString(), type ? value.getClass().getSimpleName() : null, this.getContentHandler());
    }

    public void serializeParameter(String name, Object value, boolean type) {
        if (value instanceof String) {
            this.serializeParameter(name, (String)value, type);
        } else if (value instanceof Number) {
            this.serializeParameter(name, (Number)value, type);
        } else if (value instanceof Format) {
            this.serializeParameter(name, (Format)value, type);
        } else if (value instanceof HeaderLevel) {
            this.serializeParameter(name, (HeaderLevel)value, type);
        } else if (value instanceof ListType) {
            this.serializeParameter(name, (ListType)value, type);
        } else if (value instanceof ResourceReference) {
            this.serializeParameter(name, (ResourceReference)value, type);
        } else if (value instanceof MetaData) {
            this.serializeParameter(name, (MetaData)value, type);
        } else if (value instanceof Map) {
            this.serializeParameter(name, (Map)value, type);
        }
    }

    private void startElement(String elementName, Attributes attributes) {
        SERIALIZER.startElement(elementName, attributes, this.getContentHandler());
    }

    private void endElement(String elementName) {
        SERIALIZER.endElement(elementName, this.getContentHandler());
    }
}

