/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.xdomxml.internal.version10.parser;

import javax.inject.Inject;
import org.dom4j.io.SAXContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.parser.xml.ContentHandlerStreamParser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.xdomxml.internal.parser.BlockParser;

@Component(value="xdom+xml/1.0")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class XDOMXMLContentHandlerStreamParser
extends DefaultHandler
implements ContentHandlerStreamParser {
    private Listener listener;
    private BlockParser documentParser;
    @Inject
    private ComponentManager componentManager;
    public SAXContentHandler currentDOMBuilder = new SAXContentHandler();

    public Syntax getSyntax() {
        return Syntax.XDOMXML_1_0;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.documentParser != null) {
            this.documentParser.startElement(uri, localName, qName, attributes);
        } else if ("block".equals(qName)) {
            try {
                this.documentParser = this.getDocumentBlockParser();
                this.documentParser.setListener(this.listener);
                this.documentParser.setVersion(Syntax.XDOMXML_1_0.getVersion());
                this.documentParser.startElement(uri, localName, qName, attributes);
            }
            catch (ComponentLookupException e) {
                throw new SAXException("Failed to find a document block parser", (Exception)((Object)e));
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.documentParser != null) {
            this.documentParser.characters(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.documentParser != null) {
            this.documentParser.endElement(uri, localName, qName);
        }
    }

    protected BlockParser getDocumentBlockParser() throws ComponentLookupException {
        BlockParser blockParser;
        try {
            blockParser = (BlockParser)this.componentManager.lookup(BlockParser.class, "document/" + Syntax.XDOMXML_1_0.getVersion());
        }
        catch (ComponentLookupException e1) {
            try {
                blockParser = (BlockParser)this.componentManager.lookup(BlockParser.class, "document");
            }
            catch (ComponentLookupException e2) {
                blockParser = (BlockParser)this.componentManager.lookup(BlockParser.class);
            }
        }
        return blockParser;
    }
}

