/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.xdomxml.internal.parser;

import javax.inject.Inject;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.xdomxml.internal.parser.BlockParser;

public abstract class AbstractBlockParser
extends DefaultHandler
implements BlockParser {
    @Inject
    private ComponentManager componentManager;
    private String blockName;
    private ContentHandler currentHandler;
    private int currentHandlerLevel;
    private int level = 0;
    private String blockVersion;
    private boolean beginBlockFlushed;
    private Listener listener;

    public void setComponentManager(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    @Override
    public Listener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(Listener listener) {
        this.listener = listener;
    }

    @Override
    public String getVersion() {
        return this.blockVersion;
    }

    @Override
    public void setVersion(String version) {
        this.blockVersion = version;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.currentHandler != null) {
            this.currentHandler.startElement(uri, localName, qName, attributes);
        } else {
            if (qName.equals("block")) {
                String name = attributes.getValue("name");
                String version = attributes.getValue("version");
                if (this.level == 0 && this.blockName == null) {
                    this.blockName = name;
                    this.blockVersion = version;
                } else {
                    this.flushBeginBlock();
                    try {
                        BlockParser blockParser = this.getBlockParser(name);
                        blockParser.setListener(this.getListener());
                        blockParser.setVersion(this.getVersion());
                        this.setCurrentHandler(blockParser);
                    }
                    catch (ComponentLookupException e) {
                        throw new SAXException("Failed to find a block parser for [" + name + "]", (Exception)((Object)e));
                    }
                }
            } else {
                this.startElementInternal(uri, localName, qName, attributes);
            }
            if (this.currentHandler != null) {
                this.currentHandler.startElement(uri, localName, qName, attributes);
            }
        }
        ++this.level;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentHandler != null) {
            this.currentHandler.characters(ch, start, length);
        } else {
            this.charactersInternal(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.level;
        if (this.currentHandler != null) {
            this.currentHandler.endElement(uri, localName, qName);
            if (this.level == this.currentHandlerLevel) {
                this.endElementInternal(uri, localName, qName);
                this.currentHandler = null;
            }
        } else if (this.level == 0) {
            this.flushBeginBlock();
            this.endElementInternal(uri, localName, qName);
            this.endBlock();
        } else {
            this.endElementInternal(uri, localName, qName);
        }
    }

    protected void startElementInternal(String uri, String localName, String qName, Attributes attributes) throws SAXException {
    }

    protected void charactersInternal(char[] ch, int start, int length) throws SAXException {
    }

    protected void endElementInternal(String uri, String localName, String qName) throws SAXException {
    }

    protected void beginBlock() throws SAXException {
    }

    protected void endBlock() throws SAXException {
    }

    protected void flushBeginBlock() throws SAXException {
        if (!this.beginBlockFlushed) {
            this.beginBlock();
            this.beginBlockFlushed = true;
        }
    }

    protected void setCurrentHandler(ContentHandler currentHandler) {
        this.currentHandler = currentHandler;
        this.currentHandlerLevel = this.level;
    }

    public ContentHandler getCurrentHandler() {
        return this.currentHandler;
    }

    protected BlockParser getBlockParser(String name) throws ComponentLookupException {
        BlockParser blockParser;
        try {
            blockParser = (BlockParser)this.componentManager.lookup(BlockParser.class, name.toLowerCase() + "/" + this.getVersion());
        }
        catch (ComponentLookupException e1) {
            try {
                blockParser = (BlockParser)this.componentManager.lookup(BlockParser.class, name.toLowerCase());
            }
            catch (ComponentLookupException e2) {
                blockParser = (BlockParser)this.componentManager.lookup(BlockParser.class);
            }
        }
        return blockParser;
    }
}

