/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.html;

import java.util.Map;
import org.xwiki.rendering.internal.macro.html.HTMLMacroBlockStateChainingListener;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.WrappingListener;
import org.xwiki.rendering.listener.chaining.BlockStateChainingListener;
import org.xwiki.rendering.listener.chaining.ChainingListener;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.renderer.AbstractChainingPrintRenderer;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.printer.WikiPrinter;

public class HTMLMacroChainingRenderer
extends WrappingListener
implements ChainingListener,
PrintRenderer {
    private AbstractChainingPrintRenderer printRenderer;

    public HTMLMacroChainingRenderer(AbstractChainingPrintRenderer printRenderer) {
        this.printRenderer = printRenderer;
        this.setWrappedListener((Listener)printRenderer);
    }

    private boolean isInGeneratedBlock() {
        return this.getBlockState().getMacroDepth() > 1;
    }

    public void onSpecialSymbol(char symbol) {
        if (!this.isInGeneratedBlock()) {
            this.getPrinter().print(String.valueOf(symbol));
        } else {
            super.onSpecialSymbol(symbol);
        }
    }

    public void onWord(String word) {
        if (!this.isInGeneratedBlock()) {
            this.getPrinter().print(word);
        } else {
            super.onWord(word);
        }
    }

    public void onNewLine() {
        if (!this.isInGeneratedBlock()) {
            this.getPrinter().print("\n");
        } else {
            super.onNewLine();
        }
    }

    public void onSpace() {
        if (!this.isInGeneratedBlock()) {
            this.getPrinter().print(" ");
        } else {
            super.onSpace();
        }
    }

    public void onEmptyLines(int count) {
        if (this.isInGeneratedBlock()) {
            super.onEmptyLines(count);
        }
    }

    public void beginParagraph(Map<String, String> parameters) {
        if (this.isInGeneratedBlock()) {
            super.beginParagraph(parameters);
        }
    }

    public void endParagraph(Map<String, String> parameters) {
        if (this.isInGeneratedBlock()) {
            super.endParagraph(parameters);
        }
    }

    public void onMacro(String id, Map<String, String> parameters, String content, boolean inline) {
    }

    public void beginMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
    }

    public void endMacroMarker(String name, Map<String, String> parameters, String content, boolean isInline) {
    }

    protected BlockStateChainingListener getBlockState() {
        return (BlockStateChainingListener)this.getListenerChain().getListener(HTMLMacroBlockStateChainingListener.class);
    }

    public ListenerChain getListenerChain() {
        return this.printRenderer.getListenerChain();
    }

    public WikiPrinter getPrinter() {
        return this.printRenderer.getPrinter();
    }

    public void setPrinter(WikiPrinter printer) {
        this.printRenderer.setPrinter(printer);
    }
}

