/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.stax;

import java.util.Iterator;
import javanet.staxutils.BaseXMLEventWriter;
import javanet.staxutils.DummyLocator;
import javanet.staxutils.helpers.XMLFilterImplEx;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class SAXEventWriter
extends BaseXMLEventWriter {
    private XMLFilterImplEx filter = new XMLFilterImplEx();
    private int depth;

    public SAXEventWriter(ContentHandler handler) {
        this.filter.setContentHandler(handler);
        if (handler instanceof LexicalHandler) {
            this.filter.setLexicalHandler((LexicalHandler)((Object)handler));
        }
        if (handler instanceof ErrorHandler) {
            this.filter.setErrorHandler((ErrorHandler)((Object)handler));
        }
    }

    protected void sendEvent(XMLEvent event) throws XMLStreamException {
        this.convertEvent(event);
    }

    private void convertEvent(XMLEvent event) throws XMLStreamException {
        try {
            if (event.isStartDocument()) {
                this.handleStartDocument(event);
            } else if (event.isEndDocument()) {
                this.handleEndDocument();
            } else {
                switch (event.getEventType()) {
                    case 1: {
                        ++this.depth;
                        this.handleStartElement(event.asStartElement());
                        break;
                    }
                    case 2: {
                        this.handleEndElement(event.asEndElement());
                        --this.depth;
                        if (this.depth != 0) break;
                        break;
                    }
                    case 4: {
                        this.handleCharacters(event.asCharacters());
                        break;
                    }
                    case 3: {
                        this.handlePI((ProcessingInstruction)event);
                        break;
                    }
                    case 5: {
                        this.handleComment((Comment)event);
                        break;
                    }
                    case 12: {
                        this.handleCDATA((Characters)event);
                        break;
                    }
                }
            }
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    private void handleEndDocument() throws SAXException {
        this.filter.endDocument();
    }

    private void handleStartDocument(XMLEvent event) throws SAXException {
        final Location location = event.getLocation();
        if (location != null) {
            this.filter.setDocumentLocator(new Locator(){

                @Override
                public int getColumnNumber() {
                    return location.getColumnNumber();
                }

                @Override
                public int getLineNumber() {
                    return location.getLineNumber();
                }

                @Override
                public String getPublicId() {
                    return location.getPublicId();
                }

                @Override
                public String getSystemId() {
                    return location.getSystemId();
                }
            });
        } else {
            this.filter.setDocumentLocator((Locator)new DummyLocator());
        }
        this.filter.startDocument();
    }

    private void handlePI(ProcessingInstruction event) throws SAXException {
        this.filter.processingInstruction(event.getTarget(), event.getData());
    }

    private void handleCharacters(Characters event) throws SAXException {
        this.filter.characters(event.getData().toCharArray(), 0, event.getData().length());
    }

    private void handleEndElement(EndElement event) throws XMLStreamException {
        QName qName = event.getName();
        try {
            String prefix = qName.getPrefix();
            Object rawname = prefix == null || prefix.length() == 0 ? qName.getLocalPart() : prefix + ":" + qName.getLocalPart();
            this.filter.endElement(qName.getNamespaceURI(), qName.getLocalPart(), (String)rawname);
            Iterator<Namespace> i = event.getNamespaces();
            while (i.hasNext()) {
                String nsprefix = i.next().getPrefix();
                if (nsprefix == null) {
                    nsprefix = "";
                }
                this.filter.endPrefixMapping(nsprefix);
            }
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    private void handleStartElement(StartElement event) throws XMLStreamException {
        try {
            String prefix;
            Iterator<Namespace> i = event.getNamespaces();
            while (i.hasNext()) {
                prefix = i.next().getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                this.filter.startPrefixMapping(prefix, event.getNamespaceURI(prefix));
            }
            QName qName = event.getName();
            prefix = qName.getPrefix();
            Object rawname = prefix == null || prefix.length() == 0 ? qName.getLocalPart() : prefix + ":" + qName.getLocalPart();
            Attributes saxAttrs = this.getAttributes(event);
            this.filter.startElement(qName.getNamespaceURI(), qName.getLocalPart(), (String)rawname, saxAttrs);
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    private Attributes getAttributes(StartElement event) {
        String uri;
        Iterator<Attribute> i;
        AttributesImpl attrs = new AttributesImpl();
        if (!event.isStartElement()) {
            throw new InternalError("getAttributes() attempting to process: " + String.valueOf(event));
        }
        if (this.filter.getNamespacePrefixes()) {
            i = event.getNamespaces();
            while (i.hasNext()) {
                String prefix;
                Namespace staxNamespace = (Namespace)i.next();
                uri = staxNamespace.getNamespaceURI();
                if (uri == null) {
                    uri = "";
                }
                if ((prefix = staxNamespace.getPrefix()) == null) {
                    prefix = "";
                }
                Object qName = "xmlns";
                if (prefix.length() == 0) {
                    prefix = qName;
                } else {
                    qName = (String)qName + ":" + prefix;
                }
                attrs.addAttribute("http://www.w3.org/2000/xmlns/", prefix, (String)qName, "CDATA", uri);
            }
        }
        i = event.getAttributes();
        while (i.hasNext()) {
            Attribute staxAttr = i.next();
            uri = staxAttr.getName().getNamespaceURI();
            if (uri == null) {
                uri = "";
            }
            String localName = staxAttr.getName().getLocalPart();
            String prefix = staxAttr.getName().getPrefix();
            Object qName = prefix == null || prefix.length() == 0 ? localName : prefix + ":" + localName;
            String type = staxAttr.getDTDType();
            String value = staxAttr.getValue();
            attrs.addAttribute(uri, localName, (String)qName, type, value);
        }
        return attrs;
    }

    private void handleComment(Comment comment) throws XMLStreamException {
        try {
            String text = comment.getText();
            this.filter.comment(text.toCharArray(), 0, text.length());
        }
        catch (SAXException e) {
            throw new XMLStreamException(e);
        }
    }

    private void handleCDATA(Characters event) throws SAXException {
        this.filter.startCDATA();
        this.filter.characters(event.getData().toCharArray(), 0, event.getData().length());
        this.filter.endCDATA();
    }
}

