/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html;

import jakarta.inject.Singleton;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;

@Component(roles={CachedDocumentBuilderProvider.class})
@Singleton
public class CachedDocumentBuilderProvider {
    @Inject
    private Execution execution;

    public DocumentBuilder getAvailableDocumentBuilder() throws ParserConfigurationException {
        ExecutionContext econtext = this.execution.getContext();
        if (econtext != null) {
            DocumentBuilder documentBuilder = (DocumentBuilder)econtext.getProperty(DocumentBuilder.class.getName());
            if (documentBuilder == null) {
                documentBuilder = CachedDocumentBuilderProvider.createSecureDocumentBuilder();
                econtext.setProperty(DocumentBuilder.class.getName(), (Object)documentBuilder);
            }
            return documentBuilder;
        }
        return CachedDocumentBuilderProvider.createSecureDocumentBuilder();
    }

    private static DocumentBuilder createSecureDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return factory.newDocumentBuilder();
    }
}

