/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.html;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.Attribute;
import org.jdom2.Comment;
import org.jdom2.DocType;
import org.jdom2.Document;
import org.jdom2.Namespace;
import org.jdom2.Text;
import org.jdom2.input.DOMBuilder;
import org.jdom2.output.EscapeStrategy;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.output.support.AbstractXMLOutputProcessor;
import org.jdom2.output.support.FormatStack;
import org.jdom2.output.support.XMLOutputProcessor;
import org.jdom2.util.NamespaceStack;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.xml.XMLUtils;

public final class HTMLUtils {
    private static final List<String> OMIT_ELEMENT_EXPANDING_SET = Arrays.asList("area", "base", "br", "col", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr");

    private HTMLUtils() {
    }

    public static String toString(org.w3c.dom.Document document) {
        return HTMLUtils.toString(document, false, false);
    }

    public static String toString(org.w3c.dom.Document document, boolean omitDeclaration, boolean omitDoctype) {
        DOMBuilder builder = new DOMBuilder();
        Document jdomDoc = builder.build(document);
        Format format = Format.getRawFormat();
        format.setLineSeparator("\n");
        format.setExpandEmptyElements(true);
        format.setOmitDeclaration(omitDeclaration);
        XMLOutputter outputter = new XMLOutputter(format, (XMLOutputProcessor)new XWikiXMLOutputProcessor(omitDoctype));
        return outputter.outputString(jdomDoc);
    }

    public static void stripHTMLEnvelope(org.w3c.dom.Document document) {
        Element root = document.getDocumentElement();
        if (root.getNodeName().equalsIgnoreCase("html")) {
            Node bodyNode = null;
            Node headNode = null;
            NodeList nodes = root.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeName().equalsIgnoreCase("head")) {
                    headNode = node;
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("body")) continue;
                bodyNode = node;
            }
            if (headNode != null) {
                root.removeChild(headNode);
            }
            if (bodyNode != null) {
                NodeList bodyChildrenNodes = bodyNode.getChildNodes();
                while (bodyChildrenNodes.getLength() > 0) {
                    root.insertBefore(bodyChildrenNodes.item(0), null);
                }
                root.removeChild(bodyNode);
            }
        }
    }

    public static void stripFirstElementInside(org.w3c.dom.Document document, String parentTagName, String elementTagName) {
        Node parentNode;
        Node pNode;
        NodeList parentNodes = document.getElementsByTagName(parentTagName);
        if (parentNodes.getLength() > 0 && elementTagName.equalsIgnoreCase((pNode = (parentNode = parentNodes.item(0)).getFirstChild()).getNodeName())) {
            NodeList pChildrenNodes = pNode.getChildNodes();
            while (pChildrenNodes.getLength() > 0) {
                parentNode.insertBefore(pChildrenNodes.item(0), null);
            }
            parentNode.removeChild(pNode);
        }
    }

    public static String escapeElementText(String content) {
        return XMLUtils.escapeElementText(content);
    }

    public static boolean containsElementText(CharSequence content) {
        return XMLUtils.containsElementText(content);
    }

    private static final class XWikiXMLOutputProcessor
    extends AbstractXMLOutputProcessor {
        private static final String CHARACTER_REFERENCE = "&amp;#[0-9]+;|&amp;#x[0-9a-fA-F]+;";
        private static final Pattern CHARACTER_REFERENCE_PATTERN = Pattern.compile("&amp;#[0-9]+;|&amp;#x[0-9a-fA-F]+;");
        private static final String AMPERSAND = "&amp;";
        private final boolean omitDocType;

        XWikiXMLOutputProcessor(boolean omitDocType) {
            this.omitDocType = omitDocType;
        }

        protected void printText(Writer out, FormatStack fstack, Text text) throws IOException {
            if (fstack.getEscapeOutput()) {
                String result = Format.escapeText((EscapeStrategy)fstack.getEscapeStrategy(), (String)fstack.getLineSeparator(), (String)text.getText());
                this.textRaw(out, result.replace("&#xD;", "\r"));
                return;
            }
            this.textRaw(out, text.getText());
        }

        protected void attributeEscapedEntitiesFilter(Writer out, FormatStack fstack, String value) throws IOException {
            if (!fstack.getEscapeOutput()) {
                this.write(out, value);
                return;
            }
            String result = Format.escapeAttribute((EscapeStrategy)fstack.getEscapeStrategy(), (String)value);
            this.write(out, this.cleanAmpersandEscape(result));
        }

        private String cleanAmpersandEscape(String text) {
            StringBuilder buffer = new StringBuilder(text);
            int pos = buffer.indexOf(AMPERSAND);
            while (pos > -1 && pos < buffer.length()) {
                Matcher matcher = CHARACTER_REFERENCE_PATTERN.matcher(buffer.substring(pos));
                if (matcher.lookingAt()) {
                    buffer.replace(pos, pos + 5, "&");
                    pos = pos + matcher.end() - matcher.start() - 4;
                } else {
                    pos += 5;
                }
                pos = buffer.indexOf(AMPERSAND, pos);
            }
            return buffer.toString();
        }

        protected void printDocType(Writer out, FormatStack fstack, DocType docType) throws IOException {
            if (!this.omitDocType) {
                super.printDocType(out, fstack, docType);
            }
            this.write(out, '\n');
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void printElement(Writer out, FormatStack fstack, NamespaceStack nstack, org.jdom2.Element element) throws IOException {
            if (OMIT_ELEMENT_EXPANDING_SET.contains(element.getName()) && element.getContent().isEmpty()) {
                nstack.push(element);
                try {
                    this.write(out, "<");
                    this.write(out, element.getQualifiedName());
                    for (Namespace ns : nstack.addedForward()) {
                        this.printNamespace(out, fstack, ns);
                    }
                    if (element.hasAttributes()) {
                        for (Attribute attribute : element.getAttributes()) {
                            this.printAttribute(out, fstack, attribute);
                        }
                    }
                    this.write(out, " />");
                }
                finally {
                    nstack.pop();
                }
            } else {
                super.printElement(out, fstack, nstack, element);
            }
        }

        protected void printComment(Writer out, FormatStack fstack, Comment comment) throws IOException {
            String commentText = comment.getText();
            while (commentText.startsWith(">") || commentText.startsWith("->")) {
                commentText = commentText.substring(1);
            }
            super.printComment(out, fstack, new Comment(commentText));
        }
    }
}

