/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;

@Component(roles={HTMLElementSanitizerConfiguration.class})
@Singleton
public class HTMLElementSanitizerConfiguration {
    private static final String EXTRA_ALLOWED_TAGS_CONFIGURATION = "xml.htmlElementSanitizer.extraAllowedTags";
    private static final String EXTRA_ALLOWED_ATTRIBUTES_CONFIGURATION = "xml.htmlElementSanitizer.extraAllowedAttributes";
    private static final String EXTRA_URI_SAFE_ATTRIBUTES_CONFIGURATION = "xml.htmlElementSanitizer.extraURISafeAttributes";
    private static final String EXTRA_DATA_URI_TAGS_CONFIGURATION = "xml.htmlElementSanitizer.extraDataUriTags";
    private static final String FORBID_TAGS_CONFIGURATION = "xml.htmlElementSanitizer.forbidTags";
    private static final String FORBID_ATTRIBUTES_CONFIGURATION = "xml.htmlElementSanitizer.forbidAttributes";
    private static final String ALLOW_UNKNOWN_PROTOCOLS_CONFIGURATION = "xml.htmlElementSanitizer.allowUnknownProtocols";
    private static final String ALLOWED_URI_REGEXP_CONFIGURATION = "xml.htmlElementSanitizer.allowedUriRegexp";
    @Inject
    @Named(value="restricted")
    private Provider<ConfigurationSource> configurationSourceProvider;

    private <T> T getValue(String key, Class<T> valueType, T defaultValue) {
        ConfigurationSource configurationSource = (ConfigurationSource)this.configurationSourceProvider.get();
        Object result = configurationSource != null ? configurationSource.getProperty(key, valueType, defaultValue) : defaultValue;
        return result;
    }

    public List<String> getExtraAllowedTags() {
        return this.getValue(EXTRA_ALLOWED_TAGS_CONFIGURATION, List.class, Collections.emptyList());
    }

    public List<String> getExtraAllowedAttributes() {
        return this.getValue(EXTRA_ALLOWED_ATTRIBUTES_CONFIGURATION, List.class, Collections.emptyList());
    }

    public List<String> getExtraUriSafeAttributes() {
        return this.getValue(EXTRA_URI_SAFE_ATTRIBUTES_CONFIGURATION, List.class, Collections.emptyList());
    }

    public List<String> getExtraDataUriTags() {
        return this.getValue(EXTRA_DATA_URI_TAGS_CONFIGURATION, List.class, Collections.emptyList());
    }

    public List<String> getForbidTags() {
        return this.getValue(FORBID_TAGS_CONFIGURATION, List.class, Collections.emptyList());
    }

    public List<String> getForbidAttributes() {
        return this.getValue(FORBID_ATTRIBUTES_CONFIGURATION, List.class, Collections.emptyList());
    }

    public boolean isAllowUnknownProtocols() {
        return this.getValue(ALLOW_UNKNOWN_PROTOCOLS_CONFIGURATION, Boolean.class, Boolean.TRUE);
    }

    public String getAllowedUriRegexp() {
        return this.getValue(ALLOWED_URI_REGEXP_CONFIGURATION, String.class, null);
    }
}

