/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html.filter;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.internal.html.filter.SanitizerFilter;

@Component
@Singleton
@Named(value="restrictedFilterDetector")
public class SanitizerDetectorFilter
extends SanitizerFilter {
    public static final String ATTRIBUTE_FILTERED = "restrictedFiltering";
    public static final String ID = "restrictedFilterDetector";

    @Override
    public void filter(Document document, Map<String, String> cleaningParameters) {
        AtomicBoolean filtered = new AtomicBoolean();
        this.traverseWithNamespace(document.getDocumentElement(), (element, currentNamespace) -> {
            filtered.set(filtered.get() || currentNamespace == SanitizerFilter.TagInformation.INVALID || !this.htmlElementSanitizer.isElementAllowed(element.getTagName()) || this.getAttributes((Element)element).stream().anyMatch(attr -> !this.htmlElementSanitizer.isAttributeAllowed(element.getTagName(), attr.getName(), attr.getValue())));
            filtered.set(filtered.get() || "script".equals(element.getTagName()) || "style".equals(element.getTagName()));
            return filtered.get();
        }, commentNode -> {
            filtered.set(true);
            return true;
        });
        document.getDocumentElement().setAttribute(ATTRIBUTE_FILTERED, String.valueOf(filtered.get()));
    }
}

