/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Singleton;
import org.htmlcleaner.BelongsTo;
import org.htmlcleaner.CloseTag;
import org.htmlcleaner.ContentType;
import org.htmlcleaner.Display;
import org.htmlcleaner.Html5TagProvider;
import org.htmlcleaner.TagInfo;
import org.xwiki.component.annotation.Component;

@Component(roles={XWikiHTML5TagProvider.class})
@Singleton
public class XWikiHTML5TagProvider
extends Html5TagProvider {
    private static final List<String> TAGS_WITH_EXPLICIT_PHRASING_CHILDREN = Arrays.asList("em", "strong", "small", "s", "wbr", "mark", "bdi", "time", "data", "cite", "q", "code", "bdo", "dfn", "kbd", "abbr", "var", "samp", "sub", "sup", "b", "i", "u", "rtc", "rt", "rp", "meter", "legend", "progress");

    public XWikiHTML5TagProvider() {
        this.getTagInfo("style").setBelongsTo(BelongsTo.HEAD);
        for (String string : List.of("svg", "math")) {
            TagInfo tagInfo = this.getTagInfo(string);
            tagInfo.setMustCloseTags(Collections.singleton(string));
            tagInfo.setCopyTags(Collections.emptySet());
        }
        TagInfo embedTag = this.getTagInfo("embed");
        embedTag.setDisplay(Display.any);
        embedTag.setMustCloseTags(Collections.emptySet());
        embedTag.setCopyTags(Collections.emptySet());
        for (String child : List.of("svg", "img", "data", "object", "picture", "video", "iframe", "embed", "math", "q")) {
            TAGS_WITH_EXPLICIT_PHRASING_CHILDREN.forEach(tag -> this.allowChild((String)tag, child));
        }
        this.allowChild("dl", "div");
        TagInfo tagInfo = new TagInfo("template", ContentType.all, BelongsTo.HEAD_AND_BODY, false, false, false, CloseTag.required, Display.any);
        this.put("template", tagInfo);
    }

    private void allowChild(String tagName, String childName) {
        this.getTagInfo(tagName).getChildTags().add(childName);
    }
}

