/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html.filter;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.html.HTMLElementSanitizer;
import org.xwiki.xml.html.filter.AbstractHTMLFilter;
import org.xwiki.xml.internal.html.MathMLDefinitions;
import org.xwiki.xml.internal.html.SVGDefinitions;

@Component
@Named(value="sanitizer")
@Singleton
public class SanitizerFilter
extends AbstractHTMLFilter {
    private static final String MATHML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
    private static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    private static final String HTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    @Inject
    protected HTMLElementSanitizer htmlElementSanitizer;
    @Inject
    private SVGDefinitions svgDefinitions;
    @Inject
    private MathMLDefinitions mathMLDefinitions;

    @Override
    public void filter(Document document, Map<String, String> cleaningParameters) {
        String restricted = cleaningParameters.get("restricted");
        if ("true".equalsIgnoreCase(restricted)) {
            this.cleanDocument(document.getDocumentElement());
        }
    }

    private void cleanDocument(Element rootElement) {
        ArrayList elementsToRemove = new ArrayList();
        this.traverseWithNamespace(rootElement, (element, currentNamespace) -> {
            if (currentNamespace == TagInformation.INVALID || !this.htmlElementSanitizer.isElementAllowed(element.getTagName())) {
                elementsToRemove.add(element);
                return true;
            }
            this.getAttributes((Element)element).stream().filter(attr -> !this.htmlElementSanitizer.isAttributeAllowed(element.getTagName(), attr.getName(), attr.getValue())).forEach(element::removeAttributeNode);
            return false;
        });
        elementsToRemove.forEach(element -> element.getParentNode().removeChild((Node)element));
    }

    protected void traverseWithNamespace(Element rootElement, BiPredicate<Element, TagInformation> traversal) {
        this.traverseWithNamespace(rootElement, traversal, node -> false);
    }

    protected void traverseWithNamespace(Element rootElement, BiPredicate<Element, TagInformation> traversal, Predicate<Node> commentHandler) {
        Node node = rootElement;
        ArrayDeque<TagInformation> parentNamespace = new ArrayDeque<TagInformation>();
        TagInformation currentNamespace = new TagInformation("html", HTML_NAMESPACE);
        parentNamespace.push(currentNamespace);
        while (node != null) {
            boolean skipChildren = false;
            if (node.getNodeType() == 1 && node instanceof Element) {
                Element element = node;
                currentNamespace = this.checkNamespace(element, (TagInformation)parentNamespace.peek());
                skipChildren = traversal.test(element, currentNamespace);
            } else if (node.getNodeType() == 8) {
                skipChildren = commentHandler.test(node);
            }
            if (node.getFirstChild() != null && !skipChildren) {
                node = node.getFirstChild();
                parentNamespace.push(currentNamespace);
                continue;
            }
            while (node.getNextSibling() == null && node != rootElement) {
                node = node.getParentNode();
                currentNamespace = (TagInformation)parentNamespace.pop();
            }
            node = node.getNextSibling();
        }
    }

    private TagInformation checkNamespace(Element element, TagInformation parentTag) {
        TagInformation result = TagInformation.INVALID;
        if (SVG_NAMESPACE.equals(parentTag.namespace) && this.isPureSVGTag(element.getTagName(), parentTag)) {
            result = new TagInformation(element.getTagName(), SVG_NAMESPACE);
        } else if (MATHML_NAMESPACE.equals(parentTag.namespace) && this.mathMLDefinitions.isMathMLTag(element.getTagName())) {
            result = new TagInformation(element.getTagName(), MATHML_NAMESPACE);
        } else if (this.areHTMLChildrenAllowed(parentTag)) {
            if ("math".equals(element.getTagName())) {
                result = new TagInformation(element.getTagName(), MATHML_NAMESPACE);
            } else if ("svg".equals(element.getTagName())) {
                result = new TagInformation(element.getTagName(), SVG_NAMESPACE);
            } else if (this.isPossiblyHtmlTag(element.getTagName())) {
                result = new TagInformation(element.getTagName(), HTML_NAMESPACE);
            }
        }
        return result;
    }

    private boolean isPureSVGTag(String tagName, TagInformation parentTag) {
        return this.svgDefinitions.isSVGTag(tagName) && (!this.svgDefinitions.isHTMLIntegrationPoint(parentTag.tagName) || !this.svgDefinitions.isCommonHTMLElement(tagName));
    }

    private boolean areHTMLChildrenAllowed(TagInformation parent) {
        boolean result = HTML_NAMESPACE.equals(parent.namespace);
        result = result || SVG_NAMESPACE.equals(parent.namespace) && this.svgDefinitions.isHTMLIntegrationPoint(parent.tagName);
        result = result || MATHML_NAMESPACE.equals(parent.namespace) && this.mathMLDefinitions.isTextOrHTMLIntegrationPoint(parent.tagName);
        return result;
    }

    private boolean isPossiblyHtmlTag(String tagName) {
        return !this.mathMLDefinitions.isMathMLTag(tagName) && (!this.svgDefinitions.isSVGTag(tagName) || this.svgDefinitions.isCommonHTMLElement(tagName));
    }

    protected List<Attr> getAttributes(Element element) {
        NamedNodeMap attributeNodes = element.getAttributes();
        ArrayList<Attr> result = new ArrayList<Attr>();
        int length = attributeNodes.getLength();
        for (int i = 0; i < length; ++i) {
            result.add((Attr)attributeNodes.item(i));
        }
        return result;
    }

    protected static class TagInformation {
        public static final TagInformation INVALID = new TagInformation(null, null);
        public final String tagName;
        public final String namespace;

        TagInformation(String tagName, String namespace) {
            this.tagName = tagName;
            this.namespace = namespace;
        }
    }
}

