/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import org.xwiki.xml.ExtractHandler;

public final class XMLUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLUtils.class);
    private static final String AMP = "&#38;";
    private static final Pattern AMP_PATTERN = Pattern.compile("&(?:amp|#0*+38|#x0*+26);");
    private static final String APOS = "&#39;";
    private static final Pattern APOS_PATTERN = Pattern.compile("&(?:apos|#0*+39|#x0*+27);");
    private static final String QUOT = "&#34;";
    private static final Pattern QUOT_PATTERN = Pattern.compile("&(?:quot|#0*+34|#x0*+22);");
    private static final String LCURL = "&#123;";
    private static final Pattern LCURL_PATTERN = Pattern.compile("&(?:#0*+123|#x0*+7[bB]);");
    private static final String LT = "&#60;";
    private static final Pattern LT_PATTERN = Pattern.compile("&(?:lt|#0*+60|#x0*+3[cC]);");
    private static final String GT = "&#62;";
    private static final Pattern GT_PATTERN = Pattern.compile("&(?:gt|#0*+62|#x0*+3[eE]);");
    private static final char[] ELEMENT_SYNTAX = new char[]{'<', '&'};
    private static final DOMImplementationLS LS_IMPL;
    private static final String DISABLE_DTD_PARAM = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String DISABLE_EXTERNAL_DOCTYPE_DECLARATION = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String DISABLE_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String DISABLE_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final ErrorListener RELAXED_ERROR_LISTENER;

    private XMLUtils() {
    }

    public static String extractXML(Node node, int start, int length) {
        ExtractHandler handler = null;
        try {
            handler = new ExtractHandler(start, length);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setErrorListener(RELAXED_ERROR_LISTENER);
            xformer.transform(new DOMSource(node), new SAXResult(handler));
            return handler.getResult();
        }
        catch (Throwable t) {
            if (handler != null && handler.isFinished()) {
                return handler.getResult();
            }
            throw new RuntimeException("Failed to extract XML", t);
        }
    }

    public static String escapeXMLComment(String content) {
        StringBuffer str = new StringBuffer(content.length());
        char[] buff = content.toCharArray();
        int lastChar = 0;
        for (int n : buff) {
            if (n == 92) {
                str.append('\\');
            } else if (n == 45 && lastChar == 45) {
                str.append('\\');
            }
            str.append((char)n);
            lastChar = n;
        }
        if (lastChar == 45) {
            str.append('\\');
        }
        return str.toString();
    }

    public static String unescapeXMLComment(String content) {
        StringBuffer str = new StringBuffer(content.length());
        char[] buff = content.toCharArray();
        boolean escaped = false;
        for (char c : buff) {
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            str.append(c);
            escaped = false;
        }
        return str.toString();
    }

    @Deprecated
    public static String escape(Object content) {
        return XMLUtils.escape(Objects.toString(content, null));
    }

    public static String escape(String content) {
        return XMLUtils.escapeAttributeValue(content);
    }

    @Deprecated
    public static String escapeAttributeValue(Object content) {
        if (content == null) {
            return null;
        }
        return XMLUtils.escapeAttributeValue(String.valueOf(content));
    }

    public static String escapeAttributeValue(String content) {
        if (content == null) {
            return null;
        }
        StringBuilder result = new StringBuilder((int)((double)content.length() * 1.1));
        int length = content.length();
        block8: for (int i = 0; i < length; ++i) {
            char c = content.charAt(i);
            switch (c) {
                case '&': {
                    result.append(AMP);
                    continue block8;
                }
                case '\'': {
                    result.append(APOS);
                    continue block8;
                }
                case '\"': {
                    result.append(QUOT);
                    continue block8;
                }
                case '<': {
                    result.append(LT);
                    continue block8;
                }
                case '>': {
                    result.append(GT);
                    continue block8;
                }
                case '{': {
                    result.append(LCURL);
                    continue block8;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String escapeElementText(String content) {
        if (content == null) {
            return null;
        }
        int contentLength = content.length();
        StringBuilder result = new StringBuilder((int)((double)contentLength * 1.1));
        block5: for (int i = 0; i < contentLength; ++i) {
            char c = content.charAt(i);
            switch (c) {
                case '&': {
                    result.append(AMP);
                    continue block5;
                }
                case '<': {
                    result.append(LT);
                    continue block5;
                }
                case '{': {
                    result.append(LCURL);
                    continue block5;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static boolean containsElementText(CharSequence content) {
        return StringUtils.containsAny((CharSequence)content, (char[])ELEMENT_SYNTAX);
    }

    @Deprecated
    public static String escapeElementContent(Object content) {
        if (content == null) {
            return null;
        }
        String str = String.valueOf(content);
        StringBuilder result = new StringBuilder((int)((double)str.length() * 1.1));
        int length = str.length();
        block5: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '&': {
                    result.append(AMP);
                    continue block5;
                }
                case '<': {
                    result.append(LT);
                    continue block5;
                }
                case '>': {
                    result.append(GT);
                    continue block5;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    @Deprecated
    public static String unescape(Object content) {
        if (content == null) {
            return null;
        }
        String str = String.valueOf(content);
        str = APOS_PATTERN.matcher(str).replaceAll("'");
        str = QUOT_PATTERN.matcher(str).replaceAll("\"");
        str = LT_PATTERN.matcher(str).replaceAll("<");
        str = GT_PATTERN.matcher(str).replaceAll(">");
        str = AMP_PATTERN.matcher(str).replaceAll("&");
        str = LCURL_PATTERN.matcher(str).replaceAll("{");
        return str;
    }

    public static Document createDOMDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            LOGGER.error("Cannot create DOM Documents", (Throwable)ex);
            return null;
        }
    }

    public static Document parse(LSInput source) {
        try {
            LSParser p = LS_IMPL.createLSParser((short)1, null);
            p.getDomConfig().setParameter("validate", false);
            if (p.getDomConfig().canSetParameter(DISABLE_DTD_PARAM, false)) {
                p.getDomConfig().setParameter(DISABLE_DTD_PARAM, false);
            }
            if (p.getDomConfig().canSetParameter(DISABLE_EXTERNAL_DOCTYPE_DECLARATION, false)) {
                p.getDomConfig().setParameter(DISABLE_EXTERNAL_DOCTYPE_DECLARATION, false);
            }
            if (p.getDomConfig().canSetParameter(DISABLE_EXTERNAL_PARAMETER_ENTITIES, false)) {
                p.getDomConfig().setParameter(DISABLE_EXTERNAL_PARAMETER_ENTITIES, false);
            }
            if (p.getDomConfig().canSetParameter(DISABLE_EXTERNAL_GENERAL_ENTITIES, false)) {
                p.getDomConfig().setParameter(DISABLE_EXTERNAL_GENERAL_ENTITIES, false);
            }
            return p.parse(source);
        }
        catch (Exception ex) {
            LOGGER.warn("Cannot parse XML document: [{}]", (Object)ex.getMessage());
            return null;
        }
    }

    public static String serialize(Node node) {
        return XMLUtils.serialize(node, true);
    }

    public static String serialize(Node node, boolean withXmlDeclaration) {
        if (node == null) {
            return "";
        }
        try {
            LSOutput output = LS_IMPL.createLSOutput();
            StringWriter result = new StringWriter();
            output.setCharacterStream(result);
            LSSerializer serializer = LS_IMPL.createLSSerializer();
            serializer.getDomConfig().setParameter("xml-declaration", withXmlDeclaration);
            serializer.setNewLine("\n");
            String encoding = "UTF-8";
            if (node instanceof Document) {
                encoding = ((Document)node).getXmlEncoding();
            } else if (node.getOwnerDocument() != null) {
                encoding = node.getOwnerDocument().getXmlEncoding();
            }
            output.setEncoding(encoding);
            serializer.write(node, output);
            return result.toString();
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to serialize node to XML String: [{}]", (Object)ex.getMessage());
            return "";
        }
    }

    public static String transform(Source xml, Source xslt) {
        if (xml != null && xslt != null) {
            try {
                StringWriter output = new StringWriter();
                StreamResult result = new StreamResult(output);
                TransformerFactory.newInstance().newTransformer(xslt).transform(xml, result);
                return output.toString();
            }
            catch (Exception ex) {
                LOGGER.warn("Failed to apply XSLT transformation: [{}]", (Object)ex.getMessage());
            }
        }
        return null;
    }

    public static String formatXMLContent(String content) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StreamResult result = new StreamResult(new StringWriter());
        SAXSource source = new SAXSource(new InputSource(new StringReader(content)));
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            source.setXMLReader(reader);
        }
        catch (Exception e) {
            throw new TransformerException(String.format("Failed to create XML Reader while pretty-printing content [%s]", content), e);
        }
        transformer.transform(source, result);
        return result.getWriter().toString();
    }

    static {
        RELAXED_ERROR_LISTENER = new RelaxedErrorListener();
        DOMImplementationLS implementation = null;
        try {
            implementation = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS 3.0"));
        }
        catch (Exception ex) {
            LOGGER.warn("Cannot initialize the XML Script Service: [{}]", (Object)ex.getMessage());
        }
        LS_IMPL = implementation;
    }

    private static class RelaxedErrorListener
    implements ErrorListener {
        private static final String STACK_TRACE_NOTE = "stack trace for information only";

        private RelaxedErrorListener() {
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            LOGGER.warn("Fatal error from xml transformer: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)exception));
            LOGGER.trace(STACK_TRACE_NOTE, (Throwable)exception);
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            LOGGER.debug("Error [{}] from xml transformer", (Object)ExceptionUtils.getRootCauseMessage((Throwable)exception));
            LOGGER.trace(STACK_TRACE_NOTE, (Throwable)exception);
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            LOGGER.debug("Warning [{}] from xml transformer", (Object)ExceptionUtils.getRootCauseMessage((Throwable)exception));
            LOGGER.trace(STACK_TRACE_NOTE, (Throwable)exception);
        }
    }
}

