/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html;

import java.util.HashMap;
import java.util.Map;
import org.htmlcleaner.TagTransformation;

public class FontTagTransformation
extends TagTransformation {
    private static final Map<String, String> FONT_SIZE_MAP = new HashMap<String, String>();

    public FontTagTransformation() {
        super("font", "span", false);
    }

    public Map<String, String> applyTagTransformations(Map<String, String> attributes) {
        Map result = super.applyTagTransformations(attributes);
        StringBuilder builder = new StringBuilder();
        if (attributes.containsKey("color")) {
            builder.append(String.format("color:%s;", attributes.get("color")));
        }
        if (attributes.containsKey("face")) {
            builder.append(String.format("font-family:%s;", attributes.get("face")));
        }
        if (attributes.containsKey("size")) {
            String fontSize = attributes.get("size");
            String fontSizeCss = FONT_SIZE_MAP.getOrDefault(fontSize, fontSize);
            builder.append(String.format("font-size:%s;", fontSizeCss));
        }
        if (attributes.containsKey("style") && attributes.get("style").trim().length() == 0) {
            builder.append(attributes.get("style"));
        }
        if (builder.length() > 0) {
            result.put("style", builder.toString());
        }
        return result;
    }

    static {
        FONT_SIZE_MAP.put("1", "0.6em");
        FONT_SIZE_MAP.put("2", "0.8em");
        FONT_SIZE_MAP.put("3", "1.0em");
        FONT_SIZE_MAP.put("4", "1.2em");
        FONT_SIZE_MAP.put("5", "1.4em");
        FONT_SIZE_MAP.put("6", "1.6em");
        FONT_SIZE_MAP.put("7", "1.8em");
        FONT_SIZE_MAP.put("-3", "0.4em");
        FONT_SIZE_MAP.put("-2", FONT_SIZE_MAP.get("1"));
        FONT_SIZE_MAP.put("-1", FONT_SIZE_MAP.get("2"));
        FONT_SIZE_MAP.put("+1", FONT_SIZE_MAP.get("4"));
        FONT_SIZE_MAP.put("+2", FONT_SIZE_MAP.get("5"));
        FONT_SIZE_MAP.put("+3", FONT_SIZE_MAP.get("6"));
    }
}

