/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.html.filter;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.xml.html.HTMLConstants;
import org.xwiki.xml.html.filter.ElementSelector;
import org.xwiki.xml.html.filter.HTMLFilter;

public abstract class AbstractHTMLFilter
implements HTMLFilter,
HTMLConstants {
    protected List<Element> filterChildren(Element parent, String tagName) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Node current = parent.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (!current.getNodeName().equals(tagName)) continue;
            result.add((Element)current);
        }
        return result;
    }

    protected List<Element> filterDescendants(Element parent, String[] tagNames) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (String tagName : tagNames) {
            NodeList nodes = parent.getElementsByTagName(tagName);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element element = (Element)nodes.item(i);
                result.add(element);
            }
        }
        return result;
    }

    protected List<Element> filterDescendants(Element parent, String[] tagNames, ElementSelector elementSelector) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (String tagName : tagNames) {
            NodeList nodes = parent.getElementsByTagName(tagName);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element element = (Element)nodes.item(i);
                if (!elementSelector.isSelected(element)) continue;
                result.add(element);
            }
        }
        return result;
    }

    protected boolean hasAttribute(List<Element> elements, String attributeName, boolean checkValue) {
        boolean hasAttribute = true;
        if (!checkValue) {
            for (Element e : elements) {
                hasAttribute = e.hasAttribute(attributeName) && hasAttribute;
            }
        } else {
            String attributeValue = null;
            for (Element e : elements) {
                attributeValue = attributeValue == null ? e.getAttribute(attributeName) : attributeValue;
                hasAttribute = e.getAttribute(attributeName).equals(attributeValue) && hasAttribute;
            }
        }
        return hasAttribute;
    }

    protected void replaceWithChildren(Element element) {
        Element parent = (Element)element.getParentNode();
        while (element.getFirstChild() != null) {
            parent.insertBefore(element.removeChild(element.getFirstChild()), element);
        }
        parent.removeChild(element);
    }

    protected void moveChildren(Element parent, Element destination) {
        NodeList children = parent.getChildNodes();
        while (children.getLength() > 0) {
            destination.appendChild(parent.removeChild(parent.getFirstChild()));
        }
    }
}

