/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html.filter;

import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.html.filter.AbstractHTMLFilter;

@Component
@Named(value="controlcharacters")
@Singleton
public class ControlCharactersFilter
extends AbstractHTMLFilter {
    @Override
    public void filter(Document document, Map<String, String> cleaningParameters) {
        this.filterTextNodes(document);
    }

    private void filterTestNode(Text textNode) {
        String text = textNode.getTextContent();
        StringBuilder cleanedText = null;
        int cleanedIndex = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c >= '\u0001' && c < ' ' && c != '\n' && c != '\r') {
                if (cleanedText == null) {
                    cleanedText = new StringBuilder();
                }
                cleanedText.append(text.substring(cleanedIndex, i));
                cleanedText.append(' ');
                cleanedIndex = i + 1;
                continue;
            }
            if (c != '\u0000') continue;
            if (cleanedText == null) {
                cleanedText = new StringBuilder();
            }
            cleanedText.append(text.substring(cleanedIndex, i));
            cleanedText.append('\ufffd');
            cleanedIndex = i + 1;
        }
        if (cleanedText != null) {
            textNode.setData(cleanedText.toString());
        }
    }

    private void filterTextNodes(Node parentNode) {
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child instanceof Text) {
                this.filterTestNode((Text)child);
                continue;
            }
            this.filterTextNodes(child);
        }
    }
}

