/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Singleton;
import org.htmlcleaner.BelongsTo;
import org.htmlcleaner.Html5TagProvider;
import org.htmlcleaner.TagInfo;
import org.xwiki.component.annotation.Component;

@Component(roles={XWikiHTML5TagProvider.class})
@Singleton
public class XWikiHTML5TagProvider
extends Html5TagProvider {
    private static final List<String> TAGS_WITH_EXPLICIT_PHRASING_CHILDREN = Arrays.asList("em", "strong", "small", "s", "wbr", "mark", "bdi", "time", "data", "cite", "q", "code", "bdo", "dfn", "kbd", "abbr", "var", "samp", "sub", "sup", "b", "i", "u", "rtc", "rt", "rp", "meter", "legend", "progress");

    public XWikiHTML5TagProvider() {
        this.getTagInfo("style").setBelongsTo(BelongsTo.HEAD);
        TagInfo svgTag = this.getTagInfo("svg");
        svgTag.setMustCloseTags(Collections.singleton("svg"));
        svgTag.setCopyTags(Collections.emptySet());
        TAGS_WITH_EXPLICIT_PHRASING_CHILDREN.forEach(this::allowSVGChild);
        TagInfo dlTag = this.getTagInfo("dl");
        dlTag.getChildTags().add("div");
    }

    private void allowSVGChild(String tagName) {
        this.getTagInfo(tagName).getChildTags().add("svg");
    }
}

