/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html;

import java.io.Reader;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CleanerTransformations;
import org.htmlcleaner.DoctypeToken;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.TagTransformation;
import org.htmlcleaner.XWikiDOMSerializer;
import org.w3c.dom.Document;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.xml.html.HTMLCleaner;
import org.xwiki.xml.html.HTMLCleanerConfiguration;
import org.xwiki.xml.html.filter.HTMLFilter;
import org.xwiki.xml.internal.html.DefaultHTMLCleanerConfiguration;
import org.xwiki.xml.internal.html.TrimAttributeCleanerTransformations;

@Component
@Singleton
public class DefaultHTMLCleaner
implements HTMLCleaner {
    @Inject
    @Named(value="list")
    private HTMLFilter listFilter;
    @Inject
    @Named(value="listitem")
    private HTMLFilter listItemFilter;
    @Inject
    @Named(value="font")
    private HTMLFilter fontFilter;
    @Inject
    @Named(value="body")
    private HTMLFilter bodyFilter;
    @Inject
    @Named(value="attribute")
    private HTMLFilter attributeFilter;
    @Inject
    @Named(value="link")
    private HTMLFilter linkFilter;
    @Inject
    @Named(value="controlcharacters")
    private HTMLFilter controlFilter;
    @Inject
    private Execution execution;

    @Override
    public Document clean(Reader originalHtmlContent) {
        return this.clean(originalHtmlContent, this.getDefaultConfiguration());
    }

    private DocumentBuilder getAvailableDocumentBuilder() throws ParserConfigurationException {
        ExecutionContext econtext = this.execution.getContext();
        if (econtext != null) {
            DocumentBuilder documentBuilder = (DocumentBuilder)econtext.getProperty(DocumentBuilder.class.getName());
            if (documentBuilder == null) {
                documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                econtext.setProperty(DocumentBuilder.class.getName(), (Object)documentBuilder);
            }
            return documentBuilder;
        }
        return DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    @Override
    public Document clean(Reader originalHtmlContent, HTMLCleanerConfiguration configuration) {
        Document result;
        TagNode cleanedNode;
        CleanerProperties cleanerProperties = this.getDefaultCleanerProperties(configuration);
        HtmlCleaner cleaner = new HtmlCleaner(cleanerProperties);
        try {
            cleanedNode = cleaner.clean(originalHtmlContent);
        }
        catch (Exception e) {
            throw new RuntimeException("Unhandled error when cleaning HTML", e);
        }
        try {
            cleanedNode.setDocType(new DoctypeToken("html", "PUBLIC", "-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"));
            result = new XWikiDOMSerializer(cleanerProperties).createDOM(this.getAvailableDocumentBuilder(), cleanedNode);
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("Error while serializing TagNode into w3c dom.", ex);
        }
        for (HTMLFilter filter : configuration.getFilters()) {
            filter.filter(result, configuration.getParameters());
        }
        return result;
    }

    @Override
    public HTMLCleanerConfiguration getDefaultConfiguration() {
        DefaultHTMLCleanerConfiguration configuration = new DefaultHTMLCleanerConfiguration();
        configuration.setFilters(Arrays.asList(this.controlFilter, this.bodyFilter, this.listItemFilter, this.listFilter, this.fontFilter, this.attributeFilter, this.linkFilter));
        return configuration;
    }

    private CleanerProperties getDefaultCleanerProperties(HTMLCleanerConfiguration configuration) {
        CleanerProperties defaultProperties = new CleanerProperties();
        defaultProperties.setOmitUnknownTags(true);
        defaultProperties.setUseEmptyElementTags(false);
        defaultProperties.setUseCdataForScriptAndStyle(true);
        defaultProperties.setIgnoreQuestAndExclam(true);
        defaultProperties.setOmitCdataOutsideScriptAndStyle(true);
        String param = configuration.getParameters().get("namespacesAware");
        boolean namespacesAware = param != null ? Boolean.parseBoolean(param) : true;
        defaultProperties.setNamespacesAware(namespacesAware);
        defaultProperties.setCleanerTransformations(this.getDefaultCleanerTransformations(configuration));
        defaultProperties.setTranslateSpecialEntities(false);
        param = configuration.getParameters().get("useCharacterReferences");
        boolean useCharacterReferences = param != null ? Boolean.parseBoolean(param) : false;
        defaultProperties.setTransResCharsToNCR(useCharacterReferences);
        defaultProperties.setHtmlVersion(4);
        defaultProperties.setTrimAttributeValues(false);
        return defaultProperties;
    }

    private CleanerTransformations getDefaultCleanerTransformations(HTMLCleanerConfiguration configuration) {
        TrimAttributeCleanerTransformations defaultTransformations = new TrimAttributeCleanerTransformations();
        TagTransformation tt = new TagTransformation("b", "strong", false);
        defaultTransformations.addTransformation(tt);
        tt = new TagTransformation("i", "em", false);
        defaultTransformations.addTransformation(tt);
        tt = new TagTransformation("u", "ins", false);
        defaultTransformations.addTransformation(tt);
        tt = new TagTransformation("s", "del", false);
        defaultTransformations.addTransformation(tt);
        tt = new TagTransformation("strike", "del", false);
        defaultTransformations.addTransformation(tt);
        tt = new TagTransformation("center", "p", false);
        tt.addAttributeTransformation("style", "text-align:center");
        defaultTransformations.addTransformation(tt);
        String restricted = configuration.getParameters().get("restricted");
        if ("true".equalsIgnoreCase(restricted)) {
            tt = new TagTransformation("script", "pre", false);
            defaultTransformations.addTransformation(tt);
            tt = new TagTransformation("style", "pre", false);
            defaultTransformations.addTransformation(tt);
        }
        return defaultTransformations;
    }
}

