/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.websocket.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.websocket.EndpointComponent;

@Component
@Named(value="org.xwiki.websocket.internal.XWikiEndpointDispatcher")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class XWikiEndpointDispatcher
extends Endpoint
implements EndpointComponent {
    private static final Map<String, Session> SESSIONS = new ConcurrentHashMap<String, Session>();
    @Inject
    private Logger logger;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    private Endpoint endPoint;

    public void onOpen(Session session, EndpointConfig config) {
        CloseReason closeReason = null;
        try {
            EndpointComponent endPointComponent = (EndpointComponent)((ComponentManager)this.componentManagerProvider.get()).getInstance(EndpointComponent.class, (String)session.getPathParameters().get("roleHint"));
            if (!(endPointComponent instanceof XWikiEndpointDispatcher)) {
                if (endPointComponent instanceof Endpoint) {
                    Endpoint ep = (Endpoint)endPointComponent;
                    SESSIONS.put(session.getId(), session);
                    this.endPoint = ep;
                    this.endPoint.onOpen(session, config);
                } else {
                    closeReason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, String.format("The component [%s] doesn't extend Endpoint.", endPointComponent.getClass().getName()));
                }
            }
        }
        catch (ComponentLookupException e) {
            closeReason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CANNOT_ACCEPT, ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        catch (Exception e) {
            closeReason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        if (closeReason != null) {
            try {
                session.close(closeReason);
            }
            catch (IOException e) {
                this.logger.warn("Failed to close the session.", (Throwable)e);
            }
        }
    }

    public void onError(Session session, Throwable error) {
        this.logger.debug("WebSocket connection error.", error);
        SESSIONS.remove(session.getId());
        if (this.endPoint != null) {
            this.endPoint.onError(session, error);
        }
    }

    public void onClose(Session session, CloseReason reason) {
        SESSIONS.remove(session.getId());
        if (this.endPoint != null) {
            this.endPoint.onClose(session, reason);
        }
    }

    public static void closeOpenSessions(CloseReason reason) {
        HashSet<String> closedSessions = new HashSet<String>();
        for (Session session : SESSIONS.values()) {
            closedSessions.add(session.getId());
            try {
                session.close(reason);
            }
            catch (IOException iOException) {}
        }
        closedSessions.forEach(SESSIONS::remove);
    }
}

