/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.websocket.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.websocket.CloseReason;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.event.ComponentDescriptorAddedEvent;
import org.xwiki.component.event.ComponentDescriptorEvent;
import org.xwiki.component.event.ComponentDescriptorRemovedEvent;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.job.event.JobFinishedEvent;
import org.xwiki.job.event.JobStartedEvent;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationContext;
import org.xwiki.observation.event.BeginEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.websocket.EndpointComponent;
import org.xwiki.websocket.internal.XWikiEndpointDispatcher;
import org.xwiki.websocket.internal.XWikiEndpointInitializer;

@Component
@Named(value="org.xwiki.websocket.internal.XWikiEndpointListener")
@Singleton
public class XWikiEndpointListener
extends AbstractEventListener {
    public static final String HINT = "org.xwiki.websocket.internal.XWikiEndpointListener";
    static final JobStartedEvent PARENT = new JobStartedEvent();
    private static final String UPDATE = "websocket.update";
    @Inject
    private Logger logger;
    @Inject
    private ObservationContext observationContext;
    @Inject
    private Execution execution;
    @Inject
    private XWikiEndpointInitializer initializer;

    public XWikiEndpointListener() {
        super(HINT, new Event[]{new ComponentDescriptorAddedEvent(EndpointComponent.class), new ComponentDescriptorRemovedEvent(EndpointComponent.class), new JobFinishedEvent("install"), new JobFinishedEvent("uninstall")});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof ComponentDescriptorEvent) {
            this.onComponentDescriptorEvent();
        } else {
            this.flush();
        }
    }

    private void onComponentDescriptorEvent() {
        if (this.observationContext.isIn((BeginEvent)PARENT)) {
            this.updateLater();
        } else {
            this.updateNow();
        }
    }

    private void updateLater() {
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            context.setProperty(UPDATE, (Object)true);
        }
    }

    private void updateNow() {
        try {
            XWikiEndpointDispatcher.closeOpenSessions(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.SERVICE_RESTART, "The server end-point is being updated. Please reconnect."));
            ExecutionContext context = this.execution.getContext();
            if (context != null) {
                context.removeProperty(UPDATE);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to update the WebSocket end-points.", (Throwable)e);
        }
    }

    private void flush() {
        ExecutionContext context = this.execution.getContext();
        if (context != null && context.hasProperty(UPDATE)) {
            this.updateNow();
        }
    }
}

