/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.websocket.internal;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.environment.Environment;
import org.xwiki.environment.internal.ServletEnvironment;
import org.xwiki.websocket.EndpointComponent;
import org.xwiki.websocket.internal.XWikiEndpointConfigurator;
import org.xwiki.websocket.internal.XWikiEndpointDispatcher;

@Component(roles={XWikiEndpointInitializer.class})
@Singleton
public class XWikiEndpointInitializer
implements Initializable {
    @Inject
    private Logger logger;
    @Inject
    private Environment environment;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private XWikiEndpointConfigurator configurator;

    public void initialize() throws InitializationException {
        ServerContainer serverContainer = this.getServerContainer();
        if (serverContainer != null) {
            this.initialize(serverContainer);
        } else {
            this.logger.warn("The servlet container doesn't support the Java API for WebSocket (JSR 356).");
        }
    }

    private ServerContainer getServerContainer() {
        if (this.environment instanceof ServletEnvironment) {
            return (ServerContainer)((ServletEnvironment)this.environment).getServletContext().getAttribute(ServerContainer.class.getName());
        }
        this.logger.warn("We can't initialize the WebSocket end-points in a non-servlet environment.");
        return null;
    }

    private void initialize(ServerContainer container) {
        List endPoints = ((ComponentManager)this.componentManagerProvider.get()).getComponentDescriptorList(EndpointComponent.class);
        for (ComponentDescriptor endPoint : endPoints) {
            this.initialize(endPoint.getImplementation(), container);
        }
    }

    private void initialize(Class<EndpointComponent> implementation, ServerContainer container) {
        ServerEndpoint endPointConfig = implementation.getAnnotation(ServerEndpoint.class);
        if (endPointConfig != null) {
            this.initialize(ServerEndpointConfig.Builder.create(implementation, (String)("/websocket" + endPointConfig.value())).subprotocols(Arrays.asList(endPointConfig.subprotocols())).encoders(Arrays.asList(endPointConfig.encoders())).decoders(Arrays.asList(endPointConfig.decoders())), container);
        } else if (XWikiEndpointDispatcher.class.equals(implementation)) {
            this.initialize(ServerEndpointConfig.Builder.create(implementation, (String)"/websocket/{wiki}/{roleHint}"), container);
        } else if (!Endpoint.class.isAssignableFrom(implementation)) {
            this.logger.warn("The [{}] end-point should either use the @ServerEndpoint annotation or extend Endpoint.", (Object)implementation.getName());
        }
    }

    private void initialize(ServerEndpointConfig.Builder configBuilder, ServerContainer container) {
        ServerEndpointConfig config = configBuilder.configurator((ServerEndpointConfig.Configurator)this.configurator).build();
        try {
            container.addEndpoint(config);
        }
        catch (DeploymentException e) {
            this.logger.warn("Failed to deploy WebSocket end-point implemented by [{}]. Root cause is [{}].", (Object)config.getEndpointClass().getName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }
}

