/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.xar;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.xwiki.tool.xar.AbstractVerifyMojo;
import org.xwiki.tool.xar.XWikiXMLWriter;

@Mojo(name="format", threadSafe=true)
public class FormatMojo
extends AbstractVerifyMojo {
    @Parameter(property="pretty", readonly=true)
    private boolean pretty = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getProject().getPackaging().equals("xar") || this.force) {
            this.getLog().info((CharSequence)"Formatting XAR XML files...");
            this.initializePatterns();
            Collection<File> xmlFiles = this.getXARXMLFiles();
            for (File file : xmlFiles) {
                try {
                    this.format(file, this.guessDefaultLanguage(file, xmlFiles));
                }
                catch (Exception e) {
                    throw new MojoExecutionException(String.format("Failed to format file [%s]", file), e);
                }
            }
            if (this.formatLicense) {
                this.getLog().info((CharSequence)"Adding missing XAR XML license headers...");
                this.executeLicenseGoal("format");
            }
        } else {
            this.getLog().info((CharSequence)"Not a XAR module, skipping reformatting...");
        }
    }

    private void format(File file, String defaultLanguage) throws Exception {
        XWikiXMLWriter writer;
        SAXReader reader = new SAXReader();
        Document domdoc = reader.read(file);
        this.format(file.getName(), domdoc, defaultLanguage);
        if (this.pretty) {
            OutputFormat format = new OutputFormat("  ", true, "UTF-8");
            format.setExpandEmptyElements(false);
            writer = new XWikiXMLWriter(new FileOutputStream(file), format);
        } else {
            writer = new XWikiXMLWriter(new FileOutputStream(file));
        }
        writer.write(domdoc);
        writer.close();
        String parentName = file.getParentFile().getName();
        this.getLog().info((CharSequence)String.format("  Formatting [%s/%s]... ok", parentName, file.getName()));
    }

    private void format(String fileName, Document domdoc, String defaultLanguage) throws Exception {
        Node node = domdoc.selectSingleNode("xwikidoc/author");
        if (node != null) {
            node.setText("xwiki:XWiki.Admin");
        }
        if ((node = domdoc.selectSingleNode("xwikidoc/contentAuthor")) != null) {
            node.setText("xwiki:XWiki.Admin");
        }
        if ((node = domdoc.selectSingleNode("xwikidoc/creator")) != null) {
            node.setText("xwiki:XWiki.Admin");
        }
        if ((node = domdoc.selectSingleNode("xwikidoc/version")) != null) {
            node.setText("1.1");
        }
        if ((node = domdoc.selectSingleNode("xwikidoc/minorEdit")) != null) {
            node.setText("false");
        }
        for (Object attachmentAuthorNode : domdoc.selectNodes("xwikidoc/attachment/author")) {
            ((Node)attachmentAuthorNode).setText("xwiki:XWiki.Admin");
        }
        Element element = (Element)domdoc.selectSingleNode("xwikidoc/defaultLanguage");
        if (element != null) {
            if (StringUtils.isEmpty((CharSequence)defaultLanguage)) {
                this.removeContent(element);
            } else {
                element.setText(defaultLanguage);
            }
        }
        if ((element = (Element)domdoc.selectSingleNode("xwikidoc/comment")) != null) {
            this.removeContent(element);
        }
        element = (Element)domdoc.selectSingleNode("xwikidoc/hidden");
        if (this.isTechnicalPage(fileName)) {
            element.setText("true");
        }
    }

    private void removeContent(Element element) {
        if (element.hasContent()) {
            ((Node)element.content().get(0)).detach();
        }
    }
}

