/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.xar;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.xwiki.tool.xar.AbstractVerifyMojo;
import org.xwiki.tool.xar.internal.XWikiDocument;

@Mojo(name="verify", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class VerifyMojo
extends AbstractVerifyMojo {
    private static final String SYNTAX_PLAIN = "plain/1.0";
    @Parameter(property="xar.verify.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        if (!this.getProject().getPackaging().equals("xar") && !this.force) {
            this.getLog().info((CharSequence)"Not a XAR module, skipping validity check...");
            return;
        }
        this.getLog().info((CharSequence)"Checking validity of XAR XML files...");
        this.initializePatterns();
        boolean hasErrors = false;
        Collection<File> xmlFiles = this.getXARXMLFiles();
        for (File file : xmlFiles) {
            String parentName = file.getParentFile().getName();
            XWikiDocument xdoc = this.getDocFromXML(file);
            ArrayList<String> errors = new ArrayList<String>();
            if (!xdoc.getEncoding().equals("UTF-8")) {
                errors.add(String.format("Encoding must be [UTF-8] but was [%s]", xdoc.getEncoding()));
            }
            this.verifyAuthor(errors, xdoc.getAuthor(), String.format("Author must be [%s] but was [%s]", "xwiki:XWiki.Admin", xdoc.getAuthor()));
            this.verifyAuthor(errors, xdoc.getContentAuthor(), String.format("Content Author must be [%s] but was [%s]", "xwiki:XWiki.Admin", xdoc.getContentAuthor()));
            this.verifyAuthor(errors, xdoc.getCreator(), String.format("Creator must be [%s] but was [%s]", "xwiki:XWiki.Admin", xdoc.getCreator()));
            this.verifyAttachmentAuthors(errors, xdoc.getAttachmentAuthors());
            if (StringUtils.isEmpty((CharSequence)xdoc.getParent()) && !xdoc.getReference().equals("Main.WebHome")) {
                errors.add("Parent must not be empty");
            }
            if (!xdoc.getVersion().equals("1.1")) {
                errors.add(String.format("Version must be [%s] but was [%s]", "1.1", xdoc.getVersion()));
            }
            if (!StringUtils.isEmpty((CharSequence)xdoc.getComment())) {
                errors.add(String.format("Comment must be empty but was [%s]", xdoc.getComment()));
            }
            if (!xdoc.getMinorEdit().equals("false")) {
                errors.add(String.format("Minor edit must always be [false] but was [%s]", xdoc.getMinorEdit()));
            }
            String expectedDefaultLanguage = this.guessDefaultLanguage(file, xmlFiles);
            if (!xdoc.getDefaultLanguage().equals(expectedDefaultLanguage)) {
                errors.add(String.format("Default Language should have been [%s] but was [%s]", expectedDefaultLanguage, xdoc.getDefaultLanguage()));
            }
            if (this.isTechnicalPage(file.getName()) && !xdoc.isHidden()) {
                errors.add("Technical documents must be hidden");
            }
            if (!this.isTitlesMatching(xdoc.getReference(), xdoc.getTitle())) {
                errors.add(String.format("[%s] ([%s]) page must have a title matching regex [%s]", file.getName(), xdoc.getReference(), this.getTitlePatternRuleforPage(xdoc.getReference())));
            }
            if (xdoc.containsTranslations() && !xdoc.getSyntaxId().equals(SYNTAX_PLAIN)) {
                errors.add(String.format("[%s] ([%s]) page must use a [%s] syntax", file.getName(), xdoc.getReference(), SYNTAX_PLAIN));
            }
            if (errors.isEmpty()) {
                this.getLog().info((CharSequence)String.format("  Verifying [%s/%s]... ok", parentName, file.getName()));
                continue;
            }
            this.getLog().info((CharSequence)String.format("  Verifying [%s/%s]... errors", parentName, file.getName()));
            for (String error : errors) {
                this.getLog().info((CharSequence)String.format("  - %s", error));
            }
            hasErrors = true;
        }
        if (hasErrors) {
            throw new MojoFailureException("There are errors in the XAR XML files!");
        }
        if (this.formatLicense) {
            this.getLog().info((CharSequence)"Checking for missing XAR XML license headers...");
            this.executeLicenseGoal("check");
        }
    }

    private void verifyAuthor(List<String> errors, String author, String message) {
        if (!author.equals("xwiki:XWiki.Admin")) {
            errors.add(message);
        }
    }

    private void verifyAttachmentAuthors(List<String> errors, List<String> authors) {
        for (String author : authors) {
            this.verifyAuthor(errors, author, String.format("Attachment author must [%s] but was [%s]", "xwiki:XWiki.Admin", author));
        }
    }
}

